/* $Id: io_curses.h,v 1.6 1991/07/01 21:36:44 tony Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef io_curses_DEF
#define io_curses_DEF


/* The following are defined for use with get_menubar_response */
typedef struct char_opt_elt {
	char char_allowed;
	char num;
	} MENUBAR_OPT_ARR[26];

#define MENUBAR_NEVER		0			/* is never returned */
#define MENUBAR_EMPTY		1
#define MENUBAR_CHAR_ONLY	2
#define MENUBAR_CHAR_AND_NUM	3
#define MENUBAR_NUM_ONLY	4


/* The following are used to handle the formatting of output lines. */
#define R_THRESHOLD 75
#define R_INDENT 10
#define CLIP_THRESHOLD (LINES-3)


#define MAX_ANS 80

/* Macro to read characters from keyboard */
#ifdef VAX11C
#define GET_STRING(win,ans_str) {ans_str[0] = '\0'; wscanw(win,"%s",ans_str);}
#else
#define GET_STRING(win,ans_str) {ans_str[0] = '\0';\
			         getline(win,ans_str,MAX_ANS);}
#endif


#define DING (void) fprintf(stdout,"\007")   /* Ring bell - ASCII dependent */



#define START_COL 1                                  /* Where prompts start */

extern char ans_str[];
extern char bool_str[];
extern char LINE[] ;
#ifndef VAX11C                                /* UNIX curses input routines */
extern void getline();
#endif                                        /* UNIX curses input routines */
extern int get_boolean_response();
extern int get_unsigned_int_response();
extern int get_menubar_response();
extern SYMBOL get_identifier();
extern void output_centered();
extern void message_and_pause();
extern int c_prtsym();
extern void c_output_left_node();
extern void c_output_right_node();
extern int c_output_right_side();
extern void c_output_grammar_listing();
extern void c_select_grammar_rules();
extern void c_select_identifiers();
extern void c_output_rule_pair();

#endif /* ! io_curses_DEF */
