/* $Id: cagt_config.h,v 1.10 1992/07/26 23:22:42 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef cagt_config_DEF
#define cagt_config_DEF

/* Definitions that apply everywhere in cagt. This file
 * should be included in every cagt module.
*/ 

extern int errno;
#include "cagt_usr_err.h"

#include <string.h>



/*
 * The following definitions are to be used in all modules. They
 * are used by cx to generate .x files
*/
#define public                          /* public is C default scope */
#define private static                  /* static really means private */



/* a boolean type: */
typedef char boolean;

#ifdef FALSE
#undef FALSE
#endif
#define FALSE	0	

#ifdef TRUE
#undef TRUE
#endif
#define TRUE	1

/* make this a proper pointer */
#ifdef NULL
#undef NULL
#endif
#define NULL (char *) 0

/* more robust case conversion routines (as macros): */
#ifdef _toupper 
#undef _toupper
#endif
#define _toupper(c) ((c)>='a'&&(c)<='z'?(c)&0137:(c))
#ifdef _tolower 
#undef _tolower
#endif
#define _tolower(c) ((c)>='A'&&(c)<='Z'?(c)|0040:(c))

/* convert ordinal value of enum to integer */
#ifdef ORD
#undef ORD
#endif
#define ORD(e) ((int)(e))

/* in-line minimum and maximum macros - for any ordinal types */
#ifdef MIN
#undef MIN
#endif
#define MIN(x,y) (((x)<(y))?(x):(y))
#ifdef MAX
#undef MAX
#endif
#define MAX(x,y) (((x)>(y))?(x):(y))



#define GET_MEMORY(dst,ptr_cast, size_mult, itm, routine, num)\
	{\
	if ((dst =\
	    (ptr_cast) malloc((unsigned) size_mult * sizeof(itm)) ) == (ptr_cast)0)\
	   cagt_msg(0, MSG_EXIT, (cagt_msg_text, msg_arr[-(CAGT_CNTGETMEM)], routine, num))\
	}


#define FREE_MEMORY(ptr, routine, num) \
        { \
        errno = 0; \
        free((void *) ptr); \
        if (errno) \
            cagt_msg(0, MSG_EXIT, (cagt_msg_text, msg_arr[-(CAGT_CNTFREMEM)], routine, num)) }



#endif /* ! cagt_config_DEF */
