.TH eli l "8 July 1990"
.SH NAME
eli \- a system for generating language processors
.SH SYNOPSIS
.LP
.B eli
.RB [ -r "] [" -c
.I existing-cache
.RB "] [" -n
.IR created-cache ]
.RB [ -q ]
.SH DESCRIPTION
.LP
.B eli
is a complete, flexible compiler construction system.
It is intended to allow people who are not compiler experts to create
language processors.
.LP
The general problem of processing a language can be broken down into a
number of subproblems that are largely independent of one another.
Most of these subproblems have well-understood solutions.
An Eli user writes
.I specifications
that describe instances of these subproblems, rather than
.I programs
that describe their solutions.
For example, a user describes an instance of the parsing problem by writing
a context-free grammar, rather than describing its solution by writing
a parsing program.
.LP
A simple user interface provides a uniform method for requesting
construction of a processor from these specifications.
Eli determines how to actually produce the requested processor, and does so
without further user action.
The user need not be concerned with the way in which the subproblems are
solved, nor with the way in which the individual solutions are combined.
.LP
A cache of intermediate objects used in the construction of the requested
product is maintained by Eli, and when other products are requested Eli
re-uses these cached objects wherever possible instead of re-deriving them.
Explanations of the steps carried out in any derivation can be requested,
and any intermediate object can be examined if desired.
.LP
To obtain help while within Eli, respond to the
.B ->
prompt with a question mark (?) followed by a carriage return.
.LP
To exit Eli, type a Control-D in response to the
.B ->
prompt.
.SH OPTIONS
.TP
.B -r
Reset the cache directory by deleting all objects produced during
previous Eli sessions.
.TP
.BI "-c " existing-cache
Use
.I existing-cache
as the directory for storing objects produced by Eli.
.TP
.BI "-n " created-cache
Create a new directory named
.IR created-cache ,
and use it for storing objects produced by Eli.
.TP
.B -q
Quit after performing the specified cache operations.
.SH EXAMPLES
.TP
.B eli
Begin an interactive Eli session, creating a cache directory if necessary.
.TP
.B eli -r
Begin an interactive Eli session.
Before the session begins, discard all objects constructed in previous
sessions.
.TP
.BI "eli -n " created-cache
Create a cache directory named
.I created-cache
and begin an interactive Eli session using that cache.
.TP
.BI "eli -n " created-cache " -q"
Create a cache directory named
.IR created-cache ,
but do not begin an Eli session using that cache.
.TP
.BI "eli -c " existing-cache
Begin an interactive Eli session using an existing cache directory
.IR existing-cache .
.TP
.BI "eli -r -c " existing-cache
Begin an interactive Eli session using an existing cache directory
.IR existing-cache .
Before the session begins, discard all objects constructed in previous
sessions.
.SH ENVIRONMENT
.TP
.B ELI
Path name for the working cache directory.
If this variable is not set, the default path name is
.BR ./ELI .
.TP
.B ELI_SYS
Path name for the system cache directory.
If this variable is not set, the default path name is
given by the script that implements
.BR eli .
.TP
.B PRINTER
Default printer used by the print command of the Eli help system.
.TP
.B WINEDITOR
Default command for initiating a parallel editing session.
(Leave this variable unset if you are not operating under a window
manager.)
.TP
.B WINRUNNER
Default command for initiating a parallel job execution.
(Leave this variable unset if you are not operating under a window
manager.)
.SH FILES
.TP
.B $HOME/.odinrc
Sequence of requests to be made at the beginning of each interactive Eli
session.
.SH "SEE ALSO"
.TP
.I "Guide for New Eli Users".
.SH DIAGNOSTICS
.TP
.BI "Cache location not found: " existing-cache
.I existing-cache
does not exist, is inaccessible, or is not a directory.
.TP
.BI "Invalid cache at " directory
You are attempting to start an Eli session using an arbitrary Unix
directory as your cache.
Eli sessions require a cache directory with specific initial contents.
.TP
.BI "Cannot create cache directory: " created-cache
You do not have write permission for the directory in which
.I created-cache
will reside.
.TP
.BI "Cache directory is not writable: " directory
The user of a cache must be able to write into file
.IR directory /INFO
and directories
.IR directory /FILES
and
.IR directory /LOCAL.
If FILES, LOCAL and INFO are not present in
.I directory
then the user of the cache must be able to write into
.I directory
in order to establish them.
.SH BUGS
.LP
Several users can simultaneously use the same cache directory only if they are
actually executing on the same machine and the cache directory resides on a
local disc of that machine.
.LP
If an
.BI rm (1)
command is given, nfs does not always note that the file has been removed.
Thus a following
.BI ln (1)
command may fail.
This problem (which has only been observed at GMD Karlsruhe) causes random
failures in Eli derivations.
The best cure is to use a local disk for the Eli cache directory.
If that is not possible, then use the Eli
.B >:touch
derivation to invalidate one of the inputs of the step that failed.
(When Eli reports that the current request has been aborted, it is often
possible to simply repeat the request without touching anything.)
