/*
  $Id: oiladt2c.c,v 1.6 1991/08/26 17:21:27 waite Exp $
Copyright, 1989, The Regents of the University of Colorado
  */

#include "oiladt2.h"


/*****************************************************
  These are buffers for the usual ops
  */
#ifdef WithIDs
#define InitID 0,0,
#else
#define InitID 
#endif

static struct SsetSig SetArg3={ InitID nil, nil };
static struct SsetSig SetArg2={ InitID &SetArg3, nil };
static struct SsetSig SetArg1={ InitID &SetArg2, nil };


/*****************************************************
  OilIdResultTS<n> - allow for convient use of general routines
      Identify the possible result types of an applied occurance of 'id'
      using sets of types to describe the operands.
  */

tOilTypeSet  OilIdResultTS1( id, as1 )
    tOilOp id;
    tOilTypeSet as1;
  {
      SetArg3.sResultTypes= as1;
      return ( OilIdResultSet( id, &SetArg3 ));
  }

tOilTypeSet  OilIdResultTS2( id, as1, as2 )
    tOilOp id;
    tOilTypeSet as1, as2;
  {
      SetArg3.sResultTypes= as2;
      SetArg2.sResultTypes= as1;
      return ( OilIdResultSet( id, &SetArg2 ));
  }

tOilTypeSet  OilIdResultTS3( id, as1, as2, as3 )
    tOilOp id;
    tOilTypeSet as1, as2, as3;
  {
      SetArg3.sResultTypes= as3;
      SetArg2.sResultTypes= as2;
      SetArg1.sResultTypes= as1;
      return ( OilIdResultSet( id, &SetArg1 ));
  }



/*****************************************************
  OilIdOpTS<n> - allow for convienent use of general routines
      Identify an operator using type sets to describe arguments.
  */

tOilOp  OilIdOpTS1( rt, id, as1 )
    tOilType rt;
    tOilOp id;
    tOilTypeSet as1;
  {
      SetArg3.sResultTypes= as1;
      return ( OilIdOpTSn( id, &SetArg3, rt ));
  }

tOilOp  OilIdOpTS2( rt, id, as1, as2 )
    tOilType rt;
    tOilOp id;
    tOilTypeSet as1, as2;
  {
      SetArg3.sResultTypes= as2;
      SetArg2.sResultTypes= as1;
      return ( OilIdOpTSn( id, &SetArg2, rt ));
  }

tOilOp  OilIdOpTS3( rt, id, as1, as2, as3 )
    tOilType rt;
    tOilOp id;
    tOilTypeSet as1, as2, as3;
  {
      SetArg3.sResultTypes= as3;
      SetArg2.sResultTypes= as2;
      SetArg1.sResultTypes= as1;
      return ( OilIdOpTSn( id, &SetArg1, rt ));
  }


/*****************************************************
  OilIdOp<n> - allow for convienent use of general routines
      Identify an operator using simple types to describe arguments.
  */

tOilOp  OilIdOp1( id, at1 )
    tOilOp id;
    tOilType at1;
  {
      SetArg3.sResultTypes= OilTypeToSet(at1);
      return ( OilIdOpTSn( id, &SetArg3, (tOilType)nil ));
  }

tOilOp  OilIdOp2( id, at1, at2 )
    tOilOp id;
    tOilType at1, at2;
  {
      SetArg3.sResultTypes= OilTypeToSet(at2);
      SetArg2.sResultTypes= OilTypeToSet(at1);
      return ( OilIdOpTSn( id, &SetArg2, (tOilType)nil ));
  }

tOilOp  OilIdOp3( id, at1, at2, at3 )
    tOilOp id;
    tOilType at1, at2, at3;
  {
      SetArg3.sResultTypes= OilTypeToSet(at3);
      SetArg2.sResultTypes= OilTypeToSet(at2);
      SetArg1.sResultTypes= OilTypeToSet(at1);
      return ( OilIdOpTSn( id, &SetArg1, (tOilType)nil ));
  }


/*****************************************************
  OilClassInst<n> - instantiate a class with the designated number of
        parameter types.
  */

tOilType  OilClassInst0( c, id )
    tOilClass  c;
    int id;
  {
      tOilType rt;
      tOilArgSig as;
      as= OilNewArgSig();
      rt= OilNewTypeInClass( c, as, id );
      return( rt );
  }

tOilType  OilClassInst1( c, id, at1 )
    tOilClass  c;
    int id;
    tOilType  at1;
  {
       tOilType rt;
       tOilArgSig as;
       as= OilNewArgSig();
       as= OilAddArgSig( at1, as );
       rt= OilNewTypeInClass( c, as, id );
       return( rt );
  }

tOilType  OilClassInst2( c, id, at1, at2 )
    tOilClass  c;
    int id;
    tOilType  at1,  at2;
  {
       tOilType rt;
       tOilArgSig as;
       as= OilNewArgSig();
       as= OilAddArgSig( at2, as );
       as= OilAddArgSig( at1, as );
       rt= OilNewTypeInClass( c, as, id );
       return( rt );
  }



/*****************************************************
  OilTypeName, OilOpName, OilClassName - return the name attached to the 
      object
  */
int OilTypeName( obj )
    tOilType obj;
    {
	return((obj==nil)? -1 : obj->sName);
    }

int OilOpName( obj )
    tOilOp obj;
    {
	return((obj==nil)? -1 : obj->sName);
    }

int OilClassName( obj )
    tOilClass obj;
    {
	return((obj==nil)? -1 : obj->sName);
    }

/*	* *  the end of oiladt2c.c  * *		*/
