#!/bin/sh
# $Id: ligaFe.cmd,v 3.3.1.1 1992/09/22 19:11:28 kadhim Exp $
# Copyright, 1990, The University of Paderborn
 
#ligaFe <
#    showFeIdl ! 'IDL interface after frontend for show tool'*
#    fe_res[.none] 'abstract decorated grammar and tree module'*
#  > 'LIDO analysis, grammar extraction and tree module generation'*
#        USER
#                : (:lido.cmpd :cpp)
#                : (:con.cmpd :names)

umask 0
cd (|<RUNDIR|)

(|$/Tool/liga/ligaFe.exe|) (|<(:lido.cmpd :cpp)|) 1> ERRORS 2>&1

mv core* core >/dev/null 2>&1
if test -s core
then
        echo '".", line 0:0 DEADLY: Tool LIGA FRONTEND failed' >> ERRORS
fi

if test -s liga.out
then
	cp liga.out (|>showFeIdl|)
	mv liga.out (|>fe_res|)/liga.idl
else
	cp /dev/null (|>showFeIdl|)
	cp /dev/null (|>fe_res|)/liga.idl
fi

if test -s ERRORS
then
	sed -n -f (|$/Tool/liga/Cmd/mess_sort|) ERRORS
fi

if test -s WARN
then
        echo '(''|(|$/Tool/liga/Info/frontend.err|):std_err:' > (|>WARNING|)
        echo '(''|(|<(:lido.cmpd :cpp)|):cpp_err:' >> (|>WARNING|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' WARN >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
fi

if test -s ERRS
then
        echo '(''|(|$/Tool/liga/Info/frontend.err|):std_err:' > (|>ERROR|)
        echo '(''|(|<(:lido.cmpd :cpp)|):cpp_err:' >> (|>ERROR|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' ERRS >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
	exit 0
fi

# tree module
cp (|$/Tool/liga/Frames|)/treestack.h (|>fe_res|)
cp (|$/Tool/liga/Frames|)/treestack.c (|>fe_res|)
cp (|$/Tool/liga/Frames|)/gsdescr.h (|>fe_res|)
mv treecon.c (|>fe_res|)
mv treecon.h (|>fe_res|)
echo '#include "treecon.h"' > (|>fe_res|)/liga.head
echo '  InitTree ();' > (|>fe_res|)/liga.init

# grammar extraction
mv termcode.h (|>fe_res|)
#mv liga.coding (|>fe_res|)
sed -e '/^<\$START_SYMBOL>:/d' liga.coding > (|>fe_res|)/liga.coding

if test -s (|<(:con.cmpd :names)|)
then
	mv liga.dec (|>fe_res|)
else
	mv liga.dec (|>fe_res|)/liga.con
fi

exit 0

