/* $Id: IntSet.c,v 1.1 1992/09/28 11:36:29 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn  */

#include "err.h"
#include "IntSet.h"

#define maxelem	8*sizeof(IntSet)
#define noelem(el) ((el)<0 || (el>maxelem))

POSITION coord = {0, 0};

IntSet SingleIS (el)
	int	el;
{
if (noelem(el)) 
	message (DEADLY,"IntSet: SingleIS got wrong elem", el, &coord);
return ((IntSet)(0x1 << el));
}/*SingleIS*/

IntSet AddElIS (el, s)
	int	el;
	IntSet	s;
{
if (noelem(el)) 
	message (DEADLY,"IntSet: AddElIS got wrong elem", el, &coord);
return (UniteIS (SingleIS (el), s));
}/*AddElIS*/

int InIS (el, s)
	int	el;
	IntSet	s;
{
if (noelem(el)) 
	message (DEADLY,"IntSet: InIS got wrong elem", el, &coord);
return ( ( ((IntSet)(0x1 << el)) & s) != NullIS());
}/*InIS*/

IntSet UniteIS (s1,s2)
	IntSet	s1,s2;
{
return ((IntSet)(s1 | s2));
}/*UniteIS*/

IntSet InterIS (s1,s2)
	IntSet	s1,s2;
{
return ((IntSet)(s1 & s2));
}/*InterIS*/

IntSet SubIS (s1,s2)
	IntSet	s1,s2;
{
return ((IntSet)(s1 & ~s2));
}/*SubIS*/

int DisjIS (s1,s2)
	IntSet	s1,s2;
{
return (InterIS (s1,s2) == NullIS());
}/*DisjIS*/

int EmptyIS (s)
	IntSet	s;
{
return (s == NullIS());
}/*EmptyIS*/

int InclIS (s1,s2)
	IntSet	s1,s2;
{
return (InterIS (s1,s2) == s1);
}/*InclIS*/

int EqualIS (s1,s2)
	IntSet	s1,s2;
{
return (s1 == s2);
}/*EqualIS*/

int CardIS (s)
	IntSet	s;
{	int	card = 0;
while (s != NullIS()) {
	card += (s & (IntSet)0x1);
	s = (IntSet)s >> 1;
}
return (card);
}/*CardIS*/



/* for testing only :

void printIS (s)
	IntSet	s;
{	int	el = 0;
printf ("IntSet: ");
while (s != NullIS()) {
	if (s & (IntSet)0x1) printf (" %d", el);
	el++;
	s = (IntSet)s >> 1;
}
printf ("\n");
}

void main () {
IntSet s1, s2, s3;
int el1;

s1=NullIS();
printIS (s1);
for (el1=0; el1<maxelem; el1++)
	printIS (s1 = AddElIS (el1, s1));  

printIS (s1 = AddElIS (3, AddElIS (7, AddElIS (15, NullIS()))));
printf ("card = %d\n", CardIS (s1));

printIS (s2 = AddElIS (0, AddElIS (7, AddElIS (10, NullIS()))));
printf ("card = %d\n", CardIS (s2));
printIS (s3 = UniteIS (s1, s2));

printIS (InterIS (s1, s2));
printIS (InterIS (s1, s3));
printIS (InterIS (s1, NullIS()));

printIS (SubIS (s1, s2));
printIS (SubIS (s2, s1));
printIS (SubIS (s3, s1));

if (EmptyIS (NullIS())) printf ("yes\n");
if (!EmptyIS (s1)) printf ("yes\n");

if (!DisjIS (s1, s2)) printf ("yes\n");
if (DisjIS (s1, NullIS())) printf ("yes\n");

printIS (s1 = AddElIS (-1, NullIS()));
printIS (s1 = AddElIS (16, NullIS()));
printIS (s1 = SingleIS (-1));
printIS (s1 = SingleIS (127));
InIS (-1, NullIS());
InIS (16, NullIS());

}

*/

