/* $Id: int.h,v 1.6 1992/04/12 02:28:22 waite Exp $ */
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */


	/* Integer operation codes */

#define IADD 1
#define ISUB 2
#define IMUL 3
#define IDIV 4
#define IMOD 5


	/* Routines exported by the Integer Module */


#if defined(__cplusplus) || defined(__STDC__) 
extern void prtintv(FILE *d, char *i);
#else
extern void prtintv(/* FILE *d; char *i; */);
#endif
/* Print an internal integer
 *    On exit-
 *       Internal integer i has been added to the current line of d
 ***/


#if defined(__cplusplus) || defined(__STDC__) 
extern void mkint(char *c, int l, int *t, char *p);
#else
extern void mkint(/* char *c; int l, *t; char *p; */);
#endif
/* Make an internal integer value from a string of digits
 *    On entry-
 *       c points to a digit string of length l
 *    On exit-
 *       An internal integer value representing the digit string
 *          has been stored at the location pointed to by p
 ***/


#if defined(__cplusplus) || defined(__STDC__) 
extern void cvtint(int i, char *p);
#else
extern void cvtint(/* int i; char *p; */);
#endif
/* Make an internal integer from a machine integer
 *    On exit-
 *       An internal integer value representing the machine integer i
 *          has been stored at the location pointed to by p
 ***/


#if defined(__cplusplus) || defined(__STDC__) 
extern int negint(char *r, char *p);
#else
extern int negint(/* char *r, *p; */);
#endif
/* Negate an internal integer value
 *    On exit-
 *       An internal integer value representing "-r"
 *          has been stored at the location pointed to by p
 *       If the mathematical value of the expression is too large to
 *          be represented then negint = 1; otherwise negint = 0
 ***/


#if defined(__cplusplus) || defined(__STDC__) 
extern int intop(int o, char *l, char *r, char *p);
#else
extern int intop(/* int o; char *l, *r, *p; */);
#endif
/* Evaluate an expression with internal integer operands
 *    On exit-
 *       An internal integer value representing "l o r"
 *          has been stored at the location pointed to by p
 *       If the mathematical value of the expression is too large to
 *          be represented then intop = 1; otherwise intop = 0
 ***/


#if defined(__cplusplus) || defined(__STDC__) 
extern int intcmp(char *l, char *r);
#else
extern int intcmp(/* char *l, *r; */);
#endif
/* Compare two internal integer values for relative magnitude
 *    On exit-
 *       If the value of "l" is less than the value of "r" then
 *          intcmp < 0
 *       Else if the value of "l" is equal to the value of "r" then
 *          intcmp = 0
 *       Else
 *          intcmp > 0
 ***/
