#!/bin/sh
# $Id: mkfile.cmd.cpp,v 1.29 1992/10/26 22:04:10 kadhim Exp $
# Copyright, 1989, The Regents of the University of Colorado

# mkfile[.none] "Makefile for the complete program" :
# 	USER
# 		+ debug
# 		+ prof
# 		+ define
# 		: label
# 		: (:sources +incl=(:includes) ::depend :.cat)

umask 0

cd (|<RUNDIR|)

cflags=''

if test -f (|<debug|)
then cflags="-g"
fi

if test -f (|<prof|)
then

	cflags="$cflags -pg"

fi

if test -f (|<define|)
then for def in `cat (|<define|)`; do cflags="$cflags -D$def"; done
fi

cat <<END > tmp
SHELL	= /bin/sh

CFLAGS	= $cflags

END


formatter=fmt


sed -e '/:/'\!'d
		s/:.*$//
		1s/^/OBJS	= /' 			(|<(:sources +incl=(:includes) ::depend :.cat)|) 	| $formatter 	| sed -e 's/$/ \\/
		2,$s/^/	/
		$s/ \\$//' 	>> tmp

# echo 'LIBS	=' >> tmp

echo '' >> tmp

echo 'EXE	= '`sed -e 's/\..*$/.exe/' (|<label|)` >> tmp
echo '' >> tmp

echo '$(EXE):	$(OBJS)' >> tmp
echo '	$(CC) -o $(EXE) $(CFLAGS) $(OBJS)' >> tmp
echo '' >> tmp
echo 'objects: $(OBJS)' >> tmp
echo '' >> tmp
echo 'clean:' >> tmp
echo '	rm -f a.out *.o *.a *~ core ERRS $(EXE)' >> tmp
echo '' >> tmp
echo 'tidy:' >> tmp
echo '	rm -f core a.out *.o *~ *.a ERRS' >> tmp

echo '' >> tmp

cat (|<(:sources +incl=(:includes) ::depend :.cat)|) >> tmp

# Get rid of the XXX's
# These are necessary because cpp runs on this script too and we don't want
# the Makefile.cpp #ifdef's to get processed at Configure time.

sed 's/XXX//g' tmp >(|>mkfile|)/Makefile.cpp

# Create a configuration script

cat <<\END >(|>mkfile|)/Configure
#! /bin/sh

for i in *.cpp
do
	j=`echo $i | sed 's/.cpp$//'`
	echo editing $i '->' $j 
	sed -e 's/^#!/|\||shell/' -e 's/^\([ \t]*\)#\([ \t]\)/\1|\||comment\2/' 			-e 's;/\*;|\||Ccomment;' $i | 		/usr/bin/cpp -P -C 2>/dev/null | 		sed -e 's/|\||comment/#/' -e 's/^|\||shell/#!/' 			-e 's;|\||Ccomment;/*;' >$j
done
echo
echo 'Configuration complete.  Use "make" to build the processor.'
exit 0
END

chmod +x (|>mkfile|)/Configure

# Run the configuration script to produce a Makefile for this system

cd (|>mkfile|)
./Configure >/dev/null

exit 0
