#!/bin/sh
# $Id: exe.cmd.cpp,v 1.10 1992/09/21 16:41:35 kadhim Exp $
# Copyright (c) 1990, The Regents of the University of Colorado

# exe "Executable processor" :
#   USER
#      : objects
#      : (:level_8_specs +typekey=a :extract)
#      : (:level_8_specs +typekey=a :extract :labels)
#      + debug
#      + prof

umask 0
cd (|<<objects|)

if test -s (|<(:level_8_specs +typekey=a :extract)|)
then
   for f in `cat (|<(:level_8_specs +typekey=a :extract :labels)|)`
   do libs="$libs (|<<(:level_8_specs +typekey=a :extract)|)/$f"
   done
fi

if test -f (|<debug|)
then debug='-g'
elif test -f (|<prof|)

then prof='-pg'

fi

${ELI_CC-cc} -o (|>exe|) $debug $prof *.o $libs 1>(|>ERROR|) 2>&1       || echo "Loader failed with status $?" >>(|>ERROR|)

exit 0
