/************************ P A R S E R -- I N T E R F A C E ***********************/
/*                                                                               */
/* This is the interface between the parser module ( DEP ) and its environment.  */
/* DEP is a generated Directly Executable Parser. DEP is developed at University */
/* of Paderborn ( Germany ), by Markus Adam. It is adapted to the PGS - parser - */
/* interface in ELIV4.                                                           */
/*                                                                               */
/*********************************************************************************/



/******************** DEFINITIONS USED IN DIFFERENT MODULES **********************/

#include "err.h"
/*
typedef struct
   {
     int                    line;  /* The actual source line, where the token is
                                      read.                                      
     int                     col;  /* The actual source coulumn, where the token 
                                      is read.                                   
   } POSITION;                     /* This type is used to save the current  
                                      source text position of the token already 
                                      read.                                     


extern POSITION           curpos;  /* Current source text position.              
*/


typedef int         TYPE_OF_ATTR;  /* The type of the attribute of tokens.       */
typedef int      TYPE_OF_SX_CODE;  /* The type of the syntax code of tokens. 
                                      This type must be a simple type, like int 
                                      or short.                                  */



typedef struct
   {
     POSITION                Pos;  /* Current source text position.              */
     TYPE_OF_SX_CODE  SyntaxCode;  /* Syntax code of the token.                  */
     TYPE_OF_ATTR           Attr;  /* The corresponding attribute of the token.  */
   } tokentype;                    /* This type is used by the error logging and 
                                      the semantic analysis.                     */






/**************** INTERFACE OF THE PARSER TO THE CALLING MODULE ******************/


#define Parser()       Zerteiler()  /* Name of the function, which controls 
                                       the parsing.                              */ 
#define ACCEPT()            return  /* The action which will take place, after 
                                       the input file is parsed.                 */



/************* INTERFACE BETWEEN LEXICAL ANALYSIS AND THE PARSER *****************/


extern int glalex( /* int *attrval */ );  /* In this environment, GLA is used  
                                             as an lexical analyser.             */

static tokentype               descr[1],  /* This descriptor is used to save all
                                             relevant information about the
                                             current token. The type tokentype
                                             is explained above.                 */
                              old_token;  /* Old_token is used to save the token
                                             which is read just before the cur-
                                             rent token is read. It is used
                                             for semantic actions.               */


#define SCAN( sx_code_token ) \
  /* This makro - function controls the calling of the lexical analysis. */ \
   {\
     old_token    = *(descr); \
     sx_code_token = descr->SyntaxCode = glalex( &(descr->Attr) ); \
     descr->Pos    = curpos; \
   }\




/*********** INTERFACE BETWEEN ERROR HANDLER MODULE AND THE PARSER ***************/




/* This defines not needed here, because the same defines are used and defined 
   in module err.h. It is the definition for the error class.                    */
/*#define NOTE     0   Nonstandard construct                                     */
/*#define WARNING  2   Possible error                                            */
/*#define ERROR    3   Repairable error                                          */
/*#define DEADLY   5   Compiler error                                            */

/* The definition of the error text                                              */

#define FULL_QUEUE      1
#define FULL_STACK      2
#define INSERTED   	3
#define DELETED		4
#define WRONG_CALL	5
#define PARSING_ERROR	6
#define STOP		7
#define RESUMED		8
#define NO_SPACE	9



/* Every error message in DEP has four parameters. First the error class,
   second the message text, third the error state and fourth the error symbol. 
   I have omitted the text position, because it could be handeld in this frame 
   easy. The text position is clearly the text position of the current token. 
   If there is no reason to have information of one parameter, the default value 
   0 is transmitted.                                                             */

void ERR_MSG( error_class,msg_txt,error_state,error_symbol )
/* This function handle the error message                                        */
 
   int   error_class,  /* value to set the error class ( see above )             */
             msg_txt,  /* value to define the message text ( see above )         */
         error_state,  /* state, where the error occurs                          */ 
        error_symbol;  /* with this error symbol no transition could take
                          place in the current state                             */

   {
     char *msg_str;

     if( (msg_str = (char *) calloc( 35,sizeof( char ))) == NULL )
         message( DEADLY,"Can't allocate storage space",0,&((descr)->Pos) );

     switch( msg_txt )
        {
          case FULL_QUEUE      	: (void) sprintf( msg_str,
                                                  "parsing queue is flown over" );
                                  break;
          case FULL_STACK      	: (void) sprintf( msg_str,
                                                  "parsing stack is flown over" );
                                  break;
          case INSERTED   	: (void) sprintf( msg_str,"%s %d %s","token",
                                                  error_symbol,"inserted" );
                                  break;
          case DELETED		: (void) sprintf( msg_str,"%s %d %s","token",
                                                  error_symbol,"deleted" );
                                  break;
          case WRONG_CALL	: (void) sprintf( msg_str,
                                           "wrong call of function Error_Code()" );
                                  break;
          case PARSING_ERROR	: (void) sprintf( msg_str,"%s %d",
                                                  "parsing error detected in state",
                                                  error_state );
                                  break;
          case STOP		: (void) sprintf( msg_str,"parsing stopped" );
                                  break;
          case RESUMED		: (void) sprintf( msg_str,"parsing resumed here" );
                                  break;
          case NO_SPACE	        : (void) sprintf( msg_str,
                                               "could'nt allocate storage space" );
                                  break;
          default               : (void) sprintf( msg_str,
                                            "wrong call of function ERR_MSG()" );
                                  break;
        }

     message( error_class,msg_str,0,&((descr)->Pos) );


   }


/************* INTERFACE BETWEEN SEMANTIC ANALYSIS AND THE PARSER ****************/


extern void SourceNode( /* int prodcode; tokentype *old_token; */ );
/* This function is used to make structure connections.                          */

extern void SourceLeaf( /* tokentype *old_token; */ );
/* This function is used to make symbol connections.                             */

#define DEFAULT_VALUE            0  /* If a new token is generated by the error 
                                       recovery the token must get an attribute 
                                       value. DEP uses 0 as default value, like 
                                       PGS.                                      */

#define SYMB_SEM( symbol_value )    /* This definition is not used in this 
                                       adaption !! Symb_Sem described a symbol
                                       conection. In Eli for each semantic symbol 
                                       a new rule is generated and then a symbol 
                                       connection is make after rule reduction.  */

#define SYMBOL_CONNECTION_VALUE     /* This definition is not used in this 
                                       adaption !! If there exist symbol connec-
                                       tions, then this must be a synonym of the
                                       variable which saves the actual symbol 
                                       value                                     */

#define ZAttributKeller &old_token  /* DEP gets the semantic connections out
                                       of a COMMAR data structure. This connec-
                                       tions are C - strings, which represent
                                       calls of function SourceNode() and 
                                       SourceLeaf(). There the makro 
                                       ZAttributKeller is used synonym for old-
                                       token.                                    */





/************* INTERFACE OF THE ERROR RECOVERY BY J. ROEHRICH TO *****************/
/****************************** THE OTHER MODULES ********************************/

#define Gen_Token( sx_code_token,val_attribute ) \
   {\
     old_token.SyntaxCode = sx_code_token; \
     old_token.Attr       = val_attribute; \
   }
 
