
/* Copyright Massachusetts Institute of Technology 1990,1991 */

#ifndef lint
static char rcsid[] = "$Header: maybe.c,v 1.7 91/07/09 13:12:09 root Exp $";
#endif lint
/* $Log:	maybe.c,v $
 * Revision 1.7  91/07/09  13:12:09  root
 * changed args to stringOPcons to CLUREFs (sun compatibility)
 * 
 * Revision 1.6  91/06/06  13:54:59  dcurtis
 * added copyright notice
 * 
 * Revision 1.5  91/05/31  13:08:02  root
 * fixed aggregate initialization in ops_actual
 * 
 * Revision 1.4  91/05/07  14:10:30  root
 * Changed the rep to use the most negative integer for maybe$none().
 * Changed maybe$make to signal failure when passed the most negative integer.
 * 
 * Revision 1.3  91/02/21  14:34:38  dcurtis
 * added assignment to CUR_PROC_VAR for equal,similar,copy 
 * 
 * Revision 1.2  91/02/21  14:22:01  dcurtis
 * completed structures required for instantiation
 * 
 * Revision 1.1  91/02/04  23:21:33  mtv
 * Initial revision
 * 
 */

/*						*/
/*						*/
/*		IMPLEMENTATION OF		*/
/*			maybe			*/
/*						*/

#include "pclu_err.h"
#include "pclu_sys.h"

#include <sys/types.h>
#include <sys/dir.h>

extern CLUREF clu_empty_string;
extern char **environ;
extern int wrpipe;
extern int errno;

extern errcode clu_alloc();

#define MAYBE 0x80000000

typedef struct {
int count;
struct REQ_ENTRY entry[3];
} maybe_of_t_REQS;

typedef struct {
int count;
struct OP_ENTRY equal;
struct OP_ENTRY copy;
struct OP_ENTRY similar;
} maybe_of_t_TABLE;

maybe_of_t_REQS maybe_of_t_reqs_actual = {3, "equal", "copy", "similar"};
maybe_of_t_REQS *maybe_of_t_reqs = &maybe_of_t_reqs_actual;

errcode maybeOPnone(ans, elist)
CLUREF *ans;
errlist elist;
{
	ans->num = MAYBE;
	signal(ERR_ok);
	}

errcode maybeOPmake(x, ans, elist)
CLUREF x, *ans;
errlist elist;
{
errcode err;
static bool init = false;
static CLUREF error_string;

	if (x.num == MAYBE) {
		if (~init) {
			err = stringOPcons("bad MAYBE value", CLU_1, CLU_15, 
					&error_string, elist);
			init = true;
			}
		elist[0].str = error_string.str;
		signal(ERR_failure);
       		}
	ans->num = x.num;
	signal(ERR_ok);
	}

errcode maybeOPexists(m, ans, elist)
CLUREF m, *ans;
errlist elist;
{
	if (m.num == MAYBE) ans->tf = false;
	else ans->tf = true;
	signal(ERR_ok);
	}

errcode maybeOPvalue(m, ans, elist)
CLUREF m, *ans;
errlist elist;
{
	if (m.num == MAYBE) signal(ERR_wrong_tag);
	else ans->num = m.num;
	signal(ERR_ok);
	}

errcode maybeOPequal(m1, m2, ans, elist)
CLUREF m1, m2, *ans;
errlist elist;
{
errcode err;
CLUREF temp;
maybe_of_t_TABLE *table = (maybe_of_t_TABLE*)CUR_PROC_VAR.proc->type_owns->info[0];

	if (m1.num == MAYBE) {
		if (m2.num == MAYBE) ans->tf = true;
		else ans->tf = false;
		signal(ERR_ok);
		}
	if (m2.num == MAYBE) {
		ans->tf = false;
		signal(ERR_ok);
		}
	CUR_PROC_VAR.proc = table->equal.fcn;
	err = table->equal.fcn->proc(m1, m2, &temp, elist);
	if (err != ERR_ok) resignal(err);
	ans->tf = temp.tf;
	signal(ERR_ok);
	}

errcode maybeOPsimilar(m1, m2, ans, elist)
CLUREF m1, m2, *ans;
errlist elist;
{
errcode err;
CLUREF temp;
maybe_of_t_TABLE *table = (maybe_of_t_TABLE*)CUR_PROC_VAR.proc->type_owns->info[0];

	if (m1.num == MAYBE) {
		if (m2.num == MAYBE) ans->tf = true;
		else ans->tf = false;
		signal(ERR_ok);
		}
	if (m2.num == MAYBE) {
		ans->tf = false;
		signal(ERR_ok);
		}
	CUR_PROC_VAR.proc = table->similar.fcn;
	err = table->similar.fcn->proc(m1, m2, &temp, elist);
	if (err != ERR_ok) resignal(err);
	ans->tf = temp.tf;
	signal(ERR_ok);
	}

errcode maybeOPcopy(m1, ans, elist)
CLUREF m1, *ans;
errlist elist;
{
errcode err;
CLUREF temp;
maybe_of_t_TABLE *table = (maybe_of_t_TABLE*)CUR_PROC_VAR.proc->type_owns->info[0];

	if (m1.num == MAYBE) {
		ans->num = m1.num;
		signal(ERR_ok);
		}
	CUR_PROC_VAR.proc = table->copy.fcn;
	err = table->copy.fcn->proc(m1, &temp, elist);
	if (err != ERR_ok) resignal(err);
	ans->num = temp.num;
	signal(ERR_ok);
	}

typedef struct {
int count;
    OWNPTR type_owns;
    OWNPTR op_owns;
struct OP_ENTRY entry[7];
} maybe_OPS;

OWN_ptr maybe_own_init = {0, 0};

CLU_proc maybe_oe_none = {{0,0,0,0}, maybeOPnone, &maybe_own_init, &maybe_own_init};
CLU_proc maybe_oe_make = {{0,0,0,0}, maybeOPmake, &maybe_own_init, &maybe_own_init};
CLU_proc maybe_oe_exists = {{0,0,0,0}, maybeOPexists, &maybe_own_init, &maybe_own_init};
CLU_proc maybe_oe_value = {{0,0,0,0}, maybeOPvalue, &maybe_own_init, &maybe_own_init};
CLU_proc maybe_oe_equal = {{0,0,0,0}, maybeOPequal, &maybe_own_init, &maybe_own_init};
CLU_proc maybe_oe_similar = {{0,0,0,0}, maybeOPsimilar, &maybe_own_init, &maybe_own_init};
CLU_proc maybe_oe_copy = {{0,0,0,0}, maybeOPcopy, &maybe_own_init, &maybe_own_init};

OWN_req maybe_ownreqs = {8, 1};

maybe_OPS maybe_ops_actual = {7,
    &maybe_own_init,
    &maybe_own_init, {
{&maybe_oe_none, "none"},
{&maybe_oe_make, "make"},
{&maybe_oe_exists, "exists"},
{&maybe_oe_value, "value"},
{&maybe_oe_equal, "equal"},
{&maybe_oe_similar, "similar"},
{&maybe_oe_copy, "copy"}}
};

maybe_OPS *maybe_ops = &maybe_ops_actual;
