
/* Copyright Massachusetts Institute of Technology 1990,1991 */

#ifndef lint
static char rcsid[] = "$Header: file_exists.c,v 1.2 91/06/06 13:53:13 dcurtis Exp $";
#endif lint
/* $Log:	file_exists.c,v $
 * Revision 1.2  91/06/06  13:53:13  dcurtis
 * added copyright notice
 * 
 * Revision 1.1  91/02/04  23:21:14  mtv
 * Initial revision
 * 
 */

/*						*/
/*		IMPLEMENTATION OF		*/
/*			file_exists		*/
/*						*/

/*          Altered by Robert G. Fermier        */

#include "pclu_err.h"
#include "pclu_sys.h"

#include <errno.h>
extern int errno;
extern CLUREF empty_string;

errcode file_exists(fn, ans, elist)
CLUREF fn, *ans;
errlist elist;
{
errcode err;
int uerr;
CLUREF wd, name, home;

	err = file_name_fill(fn, empty_string, &name, elist);
	if (err != ERR_ok) resignal(err);

	err = file_nameOPunparse(name, &name, elist);
	if (err != ERR_ok) resignal(err);

	uerr = access(name.str->data, 0);
	if (uerr == 0) {
		ans->tf = true;
		signal(ERR_ok);
		}
	if (errno == ENOENT || errno == ENOTDIR) {
		ans->tf = false;
		signal(ERR_ok);
		}
	elist[0] = _unix_erstr(errno);
	signal(ERR_not_possible);
	}

