
/* Copyright Massachusetts Institute of Technology 1990,1991 */

/* $Header: pclu_sys.h,v 1.4 91/05/06 12:21:49 dcurtis Exp $ */
/* $Log:	pclu_sys.h,v $
 * Revision 1.4  91/05/06  12:21:49  dcurtis
 * *** empty log message ***
 * 
 * Revision 1.3  91/05/02  15:17:02  dcurtis
 * replaced a constant with a define for MAX_SIG_VALS
 * 	to ease future changes
 * 
 * Revision 1.2  91/04/02  19:40:46  mtv
 * Removed redundannt code from RecordAlloc and CellAlloc macros.
 * Updated allocation macros to work with (or without) MERGE_SIZES.
 * 
 * Revision 1.1  91/03/23  16:09:37  mtv
 * Initial revision
 * 
 */

/*						  */
/*	sys.h				          */
/*						  */
/*	Defines system constants		  */

#define GC 1
#include "gc_runtime.h"
#define dmd_gc gcollect
#define get_sp get_current_sp
#define _exit _OPexit
#define MAX_SIG_VALS 	10
#define intOPleastint	0X80000000
#define intOPmaxint	0X7FFFFFFF
#define intOPsqrtmax	46341
#define intOPmaxdigits   10

typedef int bool;
typedef int gcd_tab;
typedef char * string;

#define true 1
#define false 0

#ifndef NULL
#define NULL ((char *)0)
#endif

#define VARYING_LENGTH 1

/* GCD_REF_SIZE defines the number of bytes that gcd_tab outputs for */
/*	a small base type or a reference */
#define GCD_REF_SIZE 8

/*					*/
/*	HEADER DEFINITIONS		*/
/*					*/


/* definitions of CLUTYPE val field */
/* (AGG for aggregate covers records, structs, sequences */
/* (VAR for variant or variable covers oneofs, variants, anys */

#define CT_STRING 1
#define CT_ARRAY  2
#define CT_AGG	  3
#define CT_VAR    4
#define CT_PROC   5
#define CT_STORE  6
#define CT_TAG	  7
#define CT_REC	  8

/* may want to adjust string and header definition s.t. only
   32 bits are used for the header and the size field */

typedef struct  {
	char	mark;	/* 4 bits for gc/alloc */
	char	val;    /* type identifier */
	char	refp;   /* immediate vs indirect */
	char	spare;
	} CLUTYPE;

/*					*/
/*	STRING DEFINITIONS		*/
/*					*/


typedef char * C_STRING;

/* #define CLUSTR(x) string$cons(x, 1, strlen(x)) */

typedef struct {
	CLUTYPE   typ;
	int	  size;
	char	  data[1];
	} CLU_string;
typedef CLU_string *CLUSTRING;

#define MAX_STR 65535
#define MIN_CAP_CHAR 'A'
#define MAX_CAP_CHAR 'Z'
#define OFF_CHAR 'a' - 'A'

/*					*/
/*	SEQUENCE DEFINITIONS		*/
/*					*/

typedef struct {
	CLUTYPE	typ;
	int	size;
	int	data[1];     /* CLUREF in disguise */
	} CLU_sequence;

#define CLU_sequence_sizew 2


typedef CLU_sequence *CLUSEQ;

#define MAX_SEQ 65535		/* FIX */

/*					*/
/*	ONEOF DEFINITIONS		*/
/*					*/

#define nil 0

typedef struct {
	CLUTYPE typ;
	int	tag;
	int	value;
} CLU_cell;
#define CLU_cell_sizew 3	/* size of cell in 32-bit units */
#define cellOPmaxtag 0x3fffffff

typedef CLU_cell *CLUCELL;

/*					*/
/*	OWN PTR DEFINITIONS		*/
/*					*/


typedef struct {
int	init_flag;
int	info[VARYING_LENGTH];	/* CLUREF in disguise */
} OWN_ptr;

typedef  OWN_ptr *OWNPTR;


/*					*/
/*	OWN REQ DEFINITION		*/
/*					*/


typedef struct {
int	size;		/* sizeof own structure needed */
			/*    own structure includes owns, parm values, hints */
int	own_count;	/* number of owns */
} OWN_req;

typedef  OWN_req *OWNREQ;

/*					*/
/*	PROC VAR DEFINITIONS		*/
/*					*/

#define MAX_CONST_PARMS 7

typedef errcode PROC();
typedef struct {
	CLUTYPE typ;
	errcode (*proc)();
	OWNPTR	type_owns;
	OWNPTR  op_owns;
	} CLU_proc;

typedef CLU_proc *CLUPROC;


/*					*/
/*	PROC VAR DEFINITIONS		*/
/*	   for selectors		*/
/*					*/

typedef struct {
	CLUTYPE typ;
	errcode (*proc)();
	OWNPTR	type_owns;
	OWNPTR  op_owns;
	} CLU_selproc;

typedef CLU_selproc *CLUSELPROC;

/*					*/
/*	ARRAY DEFINITIONS		*/
/*					*/

/* arrays are implemented as two objects:		*/
/*		the array descriptor and the store      */
/*		user code sees only the descriptor	*/
/*		and the contents of the store		*/
/*		the implementation uses the store	*/
/*		to hold the user data			*/
/*		the store can be reallocated when	*/
/*		necessary				*/

typedef struct {
	CLUTYPE typ;
	int	size;
	int	data[1];	/* CLUREF in disguise */
	} CLU_store;

typedef CLU_store *CLUSTORE;
#define CLU_store_sizew 3

typedef struct {
	CLUTYPE typ;
	int	ext_low;	/* low index for user */
	int	ext_high;	/* high index for user */
	int	ext_size;	/* size for user */
	int	int_low;	/* index into store equiv to ext_low */
	int	int_size;	/* size of store */
	CLUSTORE store;
	} CLU_array;
#define CLU_array_sizew 7

typedef CLU_array *CLUARRAY;

#define MIN_ARR_INDEX intOPleastint
#define MAX_ARR_INDEX intOPmaxint
#define MAX_ARR_SIZE  (MAX_ARR_INDEX/2)

/*					*/
/*	CLUREF DEFINITIONS		*/
/*					*/


/* These are the types known by the clu runtime system */

/* may have to adjust these declarations for machines where
   a reference to a char is longer than a reference to an int */

/* possibly define CLUREF twice, once with just base types
   so that aggregates can be defined, and then the second
   time including the aggregates */

typedef union {
	char 	*ref;
	int	num;
	float	real;
	char	ch;
	bool	tf;
	unsigned short word;
	CLUSTRING str;
	CLUSEQ  vec;
	CLUCELL cell;
	CLUPROC proc;
	CLUSELPROC selproc;
	CLUARRAY array;
	CLUSTORE store;
	struct obj * obj;
} CLUREF;

extern CLUREF CUR_PROC_VAR;
extern struct OPS NO_OPS;
extern struct obj **NewObjPtr;
#ifndef util
extern CLU_proc generic_CLU_proc;
extern CLUREF CLU_string_size;
#endif

extern CLUREF _pclu_erstr();
extern CLUREF _unix_erstr();
typedef CLUREF errlist[MAX_SIG_VALS];
extern errlist elist;

/*	Storage allocation macros	*/

/*	usage: Alloc(size_in_words, result_name) */

#ifdef MERGE_SIZES
extern long size_map[];
#define FL_SIZE_MAP(sz) (size_map[sz])
#else
#define FL_SIZE_MAP(sz) (sz)
#endif

#define Alloc(Size, Result) \
	     NewObjPtr = &(objfreelist[FL_SIZE_MAP(Size)]); \
	     if(*NewObjPtr == (struct obj *)0) allocobj(Size); \
	     Result.obj = *NewObjPtr; \
	     *NewObjPtr = Result.obj->obj_link; \
	     Result.obj->obj_link = 0;

#define RecordAlloc(Size, Result) \
	     Alloc(Size + CLU_sequence_sizew, Result); \
	     Result.vec->typ.val = CT_REC; \
	     Result.vec->size = Size;

#define CellAlloc(Tag, Value, Result) \
	     Alloc(CLU_cell_sizew, Result); \
	     Result.cell->typ.val = CT_VAR; \
	     Result.cell->tag = Tag; \
	     Result.cell->value = Value;


/* 	Names for commonly used strings */

extern CLUREF		clu_empty_string;
extern CLUSTRING 	illegal_access_mode_STRING;
extern CLUSTRING	cannot_write_to_this__chan_STRING;
extern CLUSTRING	unknown_error_STRING;
extern CLUSTRING	cannot_read_from_this__chan_STRING;
extern CLUSTRING	_chan_is_closed_STRING;
extern CLUSTRING	not_a_terminal__chan_STRING;
extern CLUSTRING	speeds_unknown_STRING;
extern CLUSTRING	array_bounds_overflow_STRING;
extern CLUSTRING	cannot_get_connected_directory_STRING;
extern CLUSTRING	bad_format_STRING;
extern CLUSTRING	huge_allocation_request_STRING;
extern CLUSTRING	cannot_read_from_input__chan_STRING;
extern CLUSTRING	cannot_write_to_output__chan_STRING;
extern CLUSTRING	cannot_write_to_error__chan_STRING;
extern CLUSTRING	cannot_duplicate__chan_STRING;
extern CLUSTRING	no_return_values_STRING;
extern CLUSTRING	array_bounds_exception_STRING;

/*							*/
/*		externs for common integers		*/
/*							*/

#ifdef sparc
extern CLUREF CLU_0;
extern CLUREF CLU_1;
extern CLUREF CLU_2;
extern CLUREF CLU_3;
extern CLUREF CLU_4;
extern CLUREF CLU_5;
extern CLUREF CLU_6;
extern CLUREF CLU_7;
extern CLUREF CLU_8;
extern CLUREF CLU_9;
extern CLUREF CLU_10;
extern CLUREF CLU_11;
extern CLUREF CLU_12;
extern CLUREF CLU_13;
extern CLUREF CLU_14;
extern CLUREF CLU_15;
extern CLUREF CLU_16;
extern CLUREF CLU_17;
extern CLUREF CLU_18;
extern CLUREF CLU_19;
extern CLUREF CLU_20;
extern CLUREF CLU_21;
extern CLUREF CLU_22;
extern CLUREF CLU_23;
extern CLUREF CLU_24;
extern CLUREF CLU_25;
extern CLUREF CLU_26;
extern CLUREF CLU_27;
extern CLUREF CLU_28;
extern CLUREF CLU_29;
extern CLUREF CLU_30;
extern CLUREF CLU_31;
extern CLUREF CLU_32;
extern CLUREF CLU_33;
extern CLUREF CLU_34;
extern CLUREF CLU_35;
extern CLUREF CLU_36;
extern CLUREF CLU_37;
extern CLUREF CLU_38;
extern CLUREF CLU_39;
extern CLUREF CLU_40;
extern CLUREF CLU_41;
extern CLUREF CLU_42;
extern CLUREF CLU_43;
extern CLUREF CLU_44;
extern CLUREF CLU_45;
extern CLUREF CLU_46;
extern CLUREF CLU_47;
extern CLUREF CLU_48;
extern CLUREF CLU_49;
extern CLUREF CLU_50;
#else
#define CLU_0 0
#define CLU_1 1
#define CLU_2 2
#define CLU_3 3
#define CLU_4 4
#define CLU_5 5
#define CLU_6 6
#define CLU_7 7
#define CLU_8 8
#define CLU_9 9
#define CLU_10 10
#define CLU_11 11
#define CLU_12 12
#define CLU_13 13
#define CLU_14 14
#define CLU_15 15
#define CLU_16 16
#define CLU_17 17
#define CLU_18 18
#define CLU_19 19
#define CLU_20 20
#define CLU_21 21
#define CLU_22 22
#define CLU_23 23
#define CLU_24 24
#define CLU_25 25
#define CLU_26 26
#define CLU_27 27
#define CLU_28 28
#define CLU_29 29
#define CLU_30 30
#define CLU_31 31
#define CLU_32 32
#define CLU_33 33
#define CLU_34 34
#define CLU_35 35
#define CLU_36 36
#define CLU_37 37
#define CLU_38 38
#define CLU_39 39
#define CLU_40 40
#define CLU_41 41
#define CLU_42 42
#define CLU_43 43
#define CLU_44 44
#define CLU_45 45
#define CLU_46 46
#define CLU_47 47
#define CLU_48 48
#define CLU_49 49
#define CLU_50 50
#endif


/*							*/
/*		GENERIC PARAMETER DEFINITIONS		*/
/*							*/
struct REQ_ENTRY { 
	C_STRING name;
	};

struct REQS {
	int count;
	struct REQ_ENTRY entry[VARYING_LENGTH];
	} REQS;

struct OP_ENTRY {
	CLUPROC fcn;
	C_STRING name;
	};

struct SELOP_ENTRY {
	CLUSELPROC fcn;
	C_STRING name;
	};

struct OPS {
	int count;
	OWNPTR	type_owns;
	OWNPTR  op_owns;
	struct OP_ENTRY entry[VARYING_LENGTH];
	} OPS;

typedef struct OPS * OPSPTR;

struct SELOPS {
	int count;
	OWNPTR	type_owns;
	OWNPTR  op_owns;
	struct SELOP_ENTRY entry[VARYING_LENGTH];
	} SELOPS;

typedef struct {
	int count;
	C_STRING name[VARYING_LENGTH];
	} RLIST;

typedef struct {
	RLIST *param[VARYING_LENGTH];
	} PTABLE;

typedef struct {
	char 	*name;
	errcode (*proc)();
	bool	restricted;
	PTABLE  *restrict;
	} TG_ENTRY;

typedef struct {
	int pcount;		/* number of parameters */
	int count;		/* nubmer of operations */
	TG_ENTRY entry[VARYING_LENGTH];	/* one per operation	*/
	} TG_OPS;

struct {
	int count;
	OWNPTR	type_owns;
	OWNPTR  op_owns;
	struct OP_ENTRY entry[VARYING_LENGTH];
	} TABLE;
