
/* Copyright Massachusetts Institute of Technology 1990,1991 */

#ifndef lint
static char rcsid[] = "$Header: proctype.c,v 1.3 91/06/06 13:29:54 root Exp $";
#endif lint
/* $Log:	proctype.c,v $
 * Revision 1.3  91/06/06  13:29:54  root
 * added copyright notice
 * 
 * Revision 1.2  91/05/31  12:20:22  root
 * fixed aggregate initialization in ops_actual
 * 
 * Revision 1.1  91/02/04  15:49:49  mtv
 * Initial revision
 * 
 */

/*						*/
/*						*/
/*		IMPLEMENTATION OF		*/
/*	 	    PROCTYPE			*/
/*						*/

#include "pclu_err.h"
#include "pclu_sys.h"

extern errcode clu_alloc();

errcode proctypeOPnew(nops, ans, elist)
CLUREF nops;
CLUREF *ans;
errlist elist;
{
errcode err;
CLUREF temp;
int size;

	size = sizeof(CLU_proc);
/*	if (nops.num > 1) size += (nops.num - 1)*sizeof(struct OPS *); */
	err = clu_alloc(size, &temp, elist);
	if (err != ERR_ok) resignal(err);
	temp.proc->typ.val = CT_PROC;
	temp.proc->typ.mark = 0;
	temp.proc->typ.refp = 0;
	ans->proc = temp.proc;
	signal(ERR_ok);
	}

/* totally wrong */
errcode proctypeOPequal(x1, x2, ans, elist)
CLUREF x1, x2, *ans;
errlist elist;
{
	if (x1.proc->proc == x2.proc->proc) {
		ans->tf = true;
		}
	else ans->tf = false;
	signal(ERR_ok);
	}

/* totally wrong */
errcode proctypeOPsimilar(x1, x2, ans, elist)
CLUREF x1, x2, *ans;
errlist elist;
{
	if (x1.proc == x2.proc) ans->tf = true;
	else ans->tf = false;
	signal(ERR_ok);
	}

errcode proctypeOPcopy(x1, ans, elist)
CLUREF x1, *ans;
errlist elist;
{
	ans->proc = x1.proc;
	signal(ERR_ok);
	}



typedef struct {
int count;
    OWNPTR type_owns;
    OWNPTR op_owns;
struct OP_ENTRY entry[3];
} proctype_OPS;

OWN_ptr proctype_own_init = {1, 0};

CLU_proc proctype_oe_copy = {{0,0,0,0}, proctypeOPcopy,&proctype_own_init, &proctype_own_init};
CLU_proc proctype_oe_equal = {{0,0,0,0}, proctypeOPequal,&proctype_own_init, &proctype_own_init};
CLU_proc proctype_oe_similar = {{0,0,0,0}, proctypeOPsimilar,&proctype_own_init, &proctype_own_init};

proctype_OPS proctype_ops_actual = {3,
    &proctype_own_init,
    &proctype_own_init, {
{&proctype_oe_copy, "copy"},
{&proctype_oe_equal, "equal"},
{&proctype_oe_similar, "similar"}}
};

proctype_OPS *proctype_ops = &proctype_ops_actual;
