
/* Copyright Massachusetts Institute of Technology 1990,1991 */

#ifndef lint
static char rcsid[] = "$Header: char.c,v 1.4 91/06/06 13:26:54 root Exp $";
#endif lint
/* $Log:	char.c,v $
 * Revision 1.4  91/06/06  13:26:54  root
 * added copyright notice
 * 
 * Revision 1.3  91/05/31  12:13:13  root
 * fixed aggregate initialization in ops_actual
 * added missing signal(ERR_ok) to _gcd
 * added result variables to pstream calls
 * removed unused variable
 * corrected char value fetch in print
 * 
 * Revision 1.2  91/02/11  11:24:33  dcurtis
 * char$c2i: add "& 0xff" so that result would never be negative
 * 
 * Revision 1.1  91/02/04  15:49:40  mtv
 * Initial revision
 * 
 */


/*						*/
/*						*/
/*		IMPLEMENTATION OF		*/
/*			char			*/
/*						*/


#include "pclu_err.h"
#include "pclu_sys.h"

errcode charOPi2c(i, ans)
CLUREF i;
CLUREF *ans;
{

	if (i.num > 255 || i.num < 0) signal(ERR_illegal_char); 
	ans->ch = i.num;
	signal(ERR_ok);
	}

errcode charOPc2i(c, ans)
CLUREF c;
CLUREF *ans;
{
int temp;

	temp = (c.ch) & 0xff;
	ans->num = temp;
	signal(ERR_ok);
}

errcode charOPlt(c1, c2, ans)
CLUREF c1;
CLUREF c2;
CLUREF *ans;
{
	if (c1.ch < c2.ch) {ans->tf = true; signal(ERR_ok);}
	ans->tf = false; signal(ERR_ok);
	}

errcode charOPle(c1, c2, ans)
CLUREF c1;
CLUREF c2;
CLUREF *ans;
{
	if (c1.ch <= c2.ch) {ans->tf = true; signal(ERR_ok);}
	ans->tf = false; signal(ERR_ok);
	}


errcode charOPge(c1, c2, ans)
CLUREF c1;
CLUREF c2;
CLUREF *ans;
{
	if (c1.ch >= c2.ch) {ans->tf = true; signal(ERR_ok);}
	ans->tf = false; signal(ERR_ok);
	}

errcode charOPgt(c1, c2, ans)
CLUREF c1;
CLUREF c2;
CLUREF *ans;
{
	if (c1.ch > c2.ch) {ans->tf = true; signal(ERR_ok);}
	ans->tf = false; signal(ERR_ok);
	}

errcode charOPequal(c1, c2, ans)
CLUREF c1;
CLUREF c2;
CLUREF *ans;
{
	if (c1.ch == c2.ch) {ans->tf = true; signal(ERR_ok);}
	ans->tf = false; signal(ERR_ok);
	}

errcode charOPsimilar(c1, c2, ans)
CLUREF c1;
CLUREF c2;
CLUREF *ans;
{
	if (c1.ch == c2.ch) {ans->tf = true; signal(ERR_ok);}
	ans->tf = false; signal(ERR_ok);
	}

errcode charOPcopy(c, ans)
CLUREF c;
CLUREF *ans;
{
	ans->num = c.ch; signal(ERR_ok);
	}

errcode charOPprint(c, pst, elist)
CLUREF c, pst;
errlist elist;
{
int temp;
errcode err;
CLUREF temp_str;
static bool init = false;
static CLUREF t1, t2, t3, t4, t5, ans;
bool done = false;

	if (init == 0) {
		err = stringOPcons("'\\^", 1, 3, &t1, elist);
		err = stringOPcons("'\\!", 1, 3, &t2, elist);
		err = stringOPcons("'\\",  1, 2, &t3, elist);
		err = stringOPcons("'\\&", 1, 3, &t4, elist);
		err = stringOPcons("'",    1, 1, &t5, elist);
		init = true;
		}
	temp = c.num & 0x7f;
	if (temp == 127) {
		temp_str = t1;
		if (c.ch != temp) temp_str = t2;
		temp = '?';
		done = true;
		}
	if (!done && (temp == '\'' || temp == '\\')) {
		temp_str = t3;
		if (temp != c.ch) temp_str = t4;
		done = true;
		}
	if (!done && (' ' <= temp)) {
		temp_str = t5;
		if (temp != c.ch) temp_str = t4;
		done = true;
		}
	if (!done && (temp != c.ch)) {
		temp_str = t2;
		temp += 64;
		done = true;
		}
	if (!done && (temp == '\n')) {
		temp_str = t3;
		temp = 'n';
		done = true;
		}
	if (!done && (temp == '\t')) {
		temp_str = t3;
		temp = 't';
		done = true;
		}
	if (!done && (temp == '\f')) {
		temp_str = t3;
		temp = 'p';
		done = true;
		}
	if (!done && (temp == '\b')) {
		temp_str = t3;
		temp = 'b';
		done = true;
		}
	if (!done && (temp == '\r')) {
		temp_str = t3;
		temp = 'r';
		done = true;
		}
	if (!done && (temp == '\v')) {
		temp_str = t3;
		temp = 'v';
		done = true;
		}
	if (!done) {
		temp_str = t1;
		temp += 64;
		}
        err = pstreamOPtext(pst, temp_str, &ans, elist);
        err = pstreamOPtextc(pst, temp, &ans, elist);
        err = pstreamOPtextc(pst, '\'', &ans, elist);
	signal(ERR_ok);
	}

errcode charOPencode(c, ist, elist)
CLUREF c, ist;
errlist elist;
{
errcode err;

        err = istreamOPputi(ist, c, elist);
        if (err == ERR_not_possible) signal(err);
        if (err != ERR_ok) resignal(err);
        signal(ERR_ok);
	}

errcode charOPdecode(ist, ans, elist)
CLUREF ist, *ans;
errlist elist;
{
errcode err;
CLUREF temp;

        err = istreamOPgeti(ist, &temp, elist);
        if (err == ERR_not_possible || err == ERR_end_of_file) signal(err);
        if (err != ERR_ok) resignal(err);
        if (temp.num < 256) {
                ans->num = temp.num;
                signal(ERR_ok);
                }
        else {
                elist[0].str = bad_format_STRING;
                signal(ERR_not_possible);
                }
	}

errcode charOP_gcd(c, tab, ans)
CLUREF c;
CLUREF tab;
CLUREF *ans;
{
	ans->num = -1;
	signal(ERR_ok);
	}

typedef struct {
int count;
    OWNPTR type_owns;
    OWNPTR op_owns;
struct OP_ENTRY entry[13];
} char_OPS;

OWN_ptr char_own_init = {1, 0};

CLU_proc char_oe_i2c = {{0,0,0,0}, charOPi2c, &char_own_init, &char_own_init};
CLU_proc char_oe_c2i = {{0,0,0,0}, charOPc2i, &char_own_init, &char_own_init};
CLU_proc char_oe_lt = {{0,0,0,0}, charOPlt, &char_own_init, &char_own_init};
CLU_proc char_oe_le = {{0,0,0,0}, charOPle, &char_own_init, &char_own_init};
CLU_proc char_oe_ge = {{0,0,0,0}, charOPge, &char_own_init, &char_own_init};
CLU_proc char_oe_gt = {{0,0,0,0}, charOPgt, &char_own_init, &char_own_init};
CLU_proc char_oe_equal = {{0,0,0,0}, charOPequal, &char_own_init, &char_own_init};
CLU_proc char_oe_similar = {{0,0,0,0}, charOPsimilar, &char_own_init, &char_own_init};
CLU_proc char_oe_copy = {{0,0,0,0}, charOPcopy, &char_own_init, &char_own_init};
CLU_proc char_oe_print = {{0,0,0,0}, charOPprint, &char_own_init, &char_own_init};
CLU_proc char_oe_encode = {{0,0,0,0}, charOPencode, &char_own_init, &char_own_init};
CLU_proc char_oe_decode = {{0,0,0,0}, charOPdecode, &char_own_init, &char_own_init};
CLU_proc char_oe__gcd = {{0,0,0,0}, charOP_gcd, &char_own_init, &char_own_init};

char_OPS char_ops_actual = {13,
    &char_own_init,
    &char_own_init, {
{&char_oe_equal, "equal"},
{&char_oe_similar, "similar"},
{&char_oe_copy, "copy"},
{&char_oe_print, "print"},
{&char_oe_encode, "encode"},
{&char_oe_decode, "decode"},
{&char_oe__gcd, "_gcd"},
{&char_oe_i2c, "i2c"},
{&char_oe_c2i, "c2i"},
{&char_oe_lt, "lt"},
{&char_oe_le, "le"},
{&char_oe_ge, "ge"},
{&char_oe_gt, "gt"}}
};

char_OPS *char_ops = &char_ops_actual;
