/*
 * $Id: file_date.c,v 2.0 1992/09/23 09:27:14 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* file_date = proc(fn: file_name, read: bool) returns(date)
 *					       signals(not_possible(string))
 *	% Returns read/write date of a file.
 * 	end file_date
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/errno.h>

extern char* sys_errlist[];
extern int errno;

int _pfile_date(clus fn, bool is_atime)
{
    int except_level;
    string name;
    struct stat buf;
    long clock;
    struct tm *time;

    /*
     *	begin body
     */

    except_level = 0;

    /* fn := file_name_fill(fn, "") */
    if (_pfile_name_fill(fn, "") == SIG)
	goto sighandler;
    fn = (clus) retval_area[0];

    /* name: string := file_name$unparse(fn) */
    if (file_name_unparse(fn) == SIG)
	goto sighandler;
    name = (string) retval_area[0];

    if (stat(name, &buf) < 0) {
	/* signal not_possible(...) */
	sigarg_area[0] = (elt) sys_errlist[errno];
	signame = "not_possible";
	return SIG;
    }
    
    clock = (long) (is_atime ? buf.st_atime : buf.st_mtime);
    time = localtime((long *) &clock);
    if (_cdate_create(time->tm_mday,
		      time->tm_mon + 1,
		      time->tm_year + 1900,
		      time->tm_hour,
		      time->tm_min,
		      time->tm_sec) == 0)
	goto sighandler;

    /*	Here we have the result date object in retval_area[0], so we do not
	have to set return value into retval_area[0]. */

    return RET;

    /*
     *	end body
     */

    /*
     *	signal handler (exception hadler)
     */

 sighandler:
    switch (except_level) {
    case -1:
	string_concat("unhandle exception: ", signame);
	sigarg_area[0] = retval_area[0];
	signame = "failure";
	return (SIG);
    case 0:
	if (!strcmp(signame, "failure"))
	    return (SIG);
	else {
	    string_concat("unhandle exception: ", signame);
	    sigarg_area[0] = retval_area[0];
	    signame = "failure";
	    return (SIG);
	}
    }
}
