/*
 * $Id: string.c,v 2.0 1992/09/23 08:45:22 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* fully implemented */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

/* define for string$chars */
#define ALLOC_SZ_CHRS     4          /* allocate size for iter string$chars */
#define ARG_S_CHRS    ((string) (*ivarp)[1])   /* argment s in string$chars */
#define LV_I_CHRS     (*ivarp)[2]    /* local variable i in string$chars */
#define LV_SZ_CHRS    (*ivarp)[3]    /* local variable sz in string$chars */

/*
 *	Because a string object doesn't contain any pointer,
 *	malloc_atomic is used rather than malloc, expecting better efficiency.
 */

/*
 * size = proc(string)returns(int)
 */

int string_size(string s)
{
  retval_area[0] = strlen(s);
  return(RET);
}

/*
 * empty = proc(string)returns(bool)
 */

int string_empty(string s)
{
  retval_area[0] = !strlen(s);
  return(RET);
}

/*
 * indexs = proc(string,string)returns(int)
 */

int string_indexs(string src, string dest)
{
  int slen, dlen, i;
  char fc;
  bool same;
  
  if (!(slen = strlen(src))) {        /* if src ="" then return(1) */
    retval_area[0] = 1;
    return(RET);
  }
  dlen = strlen(dest);
  for (i = 0; i <= dlen - slen; i++) {	/* serch every dest char */
    if (!strncmp(dest++, src, slen)) {
      retval_area[0] = i+1;
      return(RET);
    }
  }
  retval_area[0] = 0;			/* when no match, then return(0) */
  return(RET);
}

/*
 * indexc = proc(char,string)returns(int)
 */

int string_indexc(char c, string dest)
{
  int dlen, i, j;
  
  dlen = strlen(dest);
  for (i = 0; i < dlen; i++)		/* serch every dest char */
    if (c == dest[i]) {
      retval_area[0] = i+1;
      return(RET);
    }

    retval_area[0] = 0;			/* when no match, then return(0) */
    return(RET);
}

/*
 * c2s = proc(char)returns(string)
 */

int string_c2s(char c)
{
  string s;
  
  s = (string) malloc_atomic(2 * sizeof(char));	/* 2 = c + '\0' */
  *s = c;
  *(s+1) = '\0';
  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * concat = proc(string,string)returns(string)
 */

int string_concat(string s1, string s2)
{
  string s;

  s = (string) malloc_atomic(strlen(s1) + strlen(s2) + 1);
  strcpy(s,s1);
  strcat(s,s2);
  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * append = proc(string,char)returns(string)
 */

int string_append(string s1, char c)
{
  string s;
  int len = strlen(s1);

  s = (string) malloc_atomic((len + 2) * sizeof(char));	/* s1 + c + '\0' */
  strcpy(s,s1);
  s[len] = c;
  s[len+1] = '\0';
  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * fetch = proc(string,int)returns(char)
 */

int string_fetch(string s, int index)
{
  if (index < 1 || index > strlen(s)) {
    signame = "bounds";
    return(SIG);
  }
  retval_area[0] = (elt) s[index - 1];
  return(RET);
}

/*
 * rest = proc(string,int)returns(string)signals(bounds)
 */

int string_rest(string s, int i)
{
  int arg_size, ret_size, j;
  string res;
  
  arg_size = strlen(s);
  if (i < 1 || i > arg_size + 1){
    signame = "bounds";
    return(SIG);
  };
  ret_size = arg_size - i + 1;
  res = (string) malloc_atomic(ret_size + 1);
  s += i - 1;
  strcpy(res, s);
  retval_area[0] = (elt) res;
  return(RET);
}

/*
 * substr = proc(string,int,int)returns(string)signals(bounds)
 *          signals(bounds,negative_size)
 */

int string_substr(string s, int top, int num)
{
  int arg_size, ret_size, i, tmp;
  string res;
  
  arg_size = strlen(s);
  if (top < 1 || top > arg_size + 1) {
    signame = "bounds";
    return(SIG);
  }
  else
    if (num < 0) {
      signame = "negative_size";
      return(SIG);
    }
  tmp = arg_size - top + 1;	/* size of string$rest(s, top) */
  ret_size = (num <= tmp) ? num : tmp;
  res = (string) malloc_atomic(ret_size + 1);
  s += top - 1;
  strncpy(res, s, ret_size);
  res[ret_size] = '\0';
  retval_area[0] = (elt) res;
  return(RET);
}	

/*
 * s2ac = proc(string)returns(array[char])
 */

int string_s2ac(string s)
{
  array ac;
  int size, i;
  
  size = strlen(s);
  ac = (array) malloc(sizeof(struct array_rep));
  ac->low = 1;
  ac->size = size;
  ac->buf_sz = (size < 5) ? 10 : size * 2;
  ac->base = ac->buf_sz / 3;
  ac->buf = (elt *) malloc(sizeof(elt)*ac->buf_sz);
  
  for (i = 0; i < size; i++)
    ac->buf[ac->base + i] = s[i];
  
  retval_area[0] = (elt) ac;
  return(RET);
}

/*
 * ac2s = proc(array[char])returns(string)
 */

int string_ac2s(array ac)
{
  string str;
  int size, i;
  
  size = ac->size;
  str = (string) malloc_atomic(size + 1);
  for (i = 0; i < size; i++)
    str[i] = (char) ac->buf[ac->base + i];
  str[size] = '\0';
  retval_area[0] = (elt) str;
  return(RET);
}

/*
 * s2sc = proc(string)returns(sequence[char])
 */

int string_s2sc(string s)
{
  int i;
  int size;
  sequence seq;

  size = strlen(s);
  seq = (sequence) malloc(sizeof(struct sequence_rep));
  seq->size = size;
  seq->buf = (elt *) malloc(size * sizeof(elt));
  for(i = 0; i < size; i++) seq->buf[i] = s[i];
 
  retval_area[0] = (elt) seq;
  return(RET);
}

/*
 * sc2s = proc(sequence[char])returns(string)
 */

int string_sc2s(sequence seq)
{
  int i;
  int size;
  char* s;

  size = seq->size;
  s = (char*)malloc_atomic(size + 1);
  for(i = 0; i < size; i++) s[i] = (char) seq->buf[i];
  s[size] = '\0';
  
  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * chars = iter(string)yields(char)
 */

int string_chars(bool init, elt **ivarp, string s)
{
  /* local var int i, sz */
  
  if (init) {               /* initial iterator call */
    *ivarp = (int*) malloc(ALLOC_SZ_CHRS*sizeof(elt));
    (*ivarp)[1] = (elt) s;
  }
  else                     /* not initial call, goto previous yield point */
    if ((*ivarp)[0] == 1) goto yield1;
  
  LV_SZ_CHRS = (elt) strlen(ARG_S_CHRS);
  
  for (LV_I_CHRS = 0; LV_I_CHRS < LV_SZ_CHRS; LV_I_CHRS++) {
    retval_area[0] = (elt) ARG_S_CHRS[LV_I_CHRS];
    (*ivarp)[0] = 1;
    return(RET);
  yield1:
    (0);
  }
  iter_end = TRUE;
  return(RET);
}

/*
 * lt = proc(string,string)returns(bool)
 */

int string_lt(string s1, string s2)
{
  retval_area[0] = (strcmp(s1, s2) < 0);
  return(RET);
}

/*
 * le = proc(string,string)returns(bool)
 */

int string_le(string s1, string s2)
{
  retval_area[0] = (strcmp(s1, s2) <= 0);
  return(RET);
}

/*
 * gt = proc(string,string)returns(bool)
 */

int string_gt(string s1, string s2)
{
  retval_area[0] = (strcmp(s1, s2) > 0);
  return(RET);
}

/*
 * ge = proc(string,string)returns(bool)
 */

int string_ge(string s1, string s2)
{
  retval_area[0] = (strcmp(s1, s2) >= 0);
  return(RET);
}

/*
 * equal = proc(string,string)returns(bool)
 */

int string_equal(string s1, string s2)
{
  retval_area[0] = !strcmp(s1, s2);
  return(RET);
}

/*
 * similar = proc(string,string)returns(bool)
 */

int string_similar(string s1, string s2)
{
  retval_area[0] = !strcmp(s1, s2);
  return(RET);
}

/*
 * copy = proc(string)returns(string)
 */

int string_copy(string s)
{
  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * print = proc(s: string, pst: pstream)
 */

int string_print(string s, clus pst)
{
    int lim, count;

    if ( _cpstream_get_max_width(pst) == SIG ) {
	out_handler();
	return(SIG);
    }
    lim = (int) retval_area[0];
    lim = lim * 16 + 4;		/* ??? */
    if ( _cpstream_textc(pst, '\"') == SIG ) {
	out_handler();
	return(SIG);
    }
    count = _string_size(s);
    if ( count > 0 ) {
	int i;
	for ( i = 0; i < count; i++ ) {
	    char nthch, lowch, outch;
	    string prefix;
	    bool meta;
	    if ( i >= lim ) {
		if ( _cpstream_text(pst, "...") == SIG ) {
		    out_handler();
		    return(SIG);
		}
		break;
	    }
	    nthch = s[i];	/* !!! assumes rep of string */
	    prefix = "";
	    meta = FALSE;
	    if ( (nthch & 0x80) != 0 ) {
		meta = TRUE;
	    }
	    lowch = nthch & 0x7f;
	    outch = lowch;
	    if (lowch == '\177') {
		prefix = "\\^";
		if ( meta ) {
		    prefix = "\\!";
		}
		outch = '?';
	    } else if ( lowch == '"' || lowch == '\\' ) {
		if ( meta ) {
		    prefix = "\\&";
		} else {
		    prefix = "\\";
		}
	    } else if ( lowch >= ' ' ) {
		if ( meta ) {
		    prefix = "\\&";
		}
	    } else if ( meta ) {
		prefix = "\\!";
		outch += 0x40;
	    } else if ( outch == '\n' ) {
		prefix = "\\";
		outch = 'n';
	    } else if ( outch == '\t' ) {
		prefix = "\\";
		outch = 't';
	    } else if ( outch == '\f' ) {
		prefix = "\\";
		outch = 'p';
	    } else if ( outch == '\b' ) {
		prefix = "\\";
		outch = 'b';
	    } else if ( outch == '\r' ) {
		prefix = "\\";
		outch = 'r';
	    } else if ( outch == '\v' ) {
		prefix = "\\";
		outch = 'v';
	    } else {
		prefix = "\\^";
		outch += 0x40;
	    }
	    if ( _cpstream_text(pst, prefix) == SIG ) {
		out_handler();
		return(SIG);
	    }
	    if ( _cpstream_textc(pst, outch) == SIG ) {
		out_handler();
		return(SIG);
	    }
	}
    }
    if ( _cpstream_textc(pst, '\"') == SIG ) {
	out_handler();
	return(SIG);
    }
    return(RET);
}
 
/*
 *  encode = proc(s: string, ist: istream) signals(not_possible(string))
 *	modifies  ist.
 *	effects  Writes an encoding of n onto the istream ist.
 */

int string_encode(string s, istream ist)
{
    int sz, i;

    sz = strlen(s);
    if (istream_puti(ist, sz) == SIG) {
	return(SIG);
    }
    for (i = 0; i < sz; i++) {
	if (istream_putc(ist, s[i]) == SIG) {
	    return(SIG);
	}
    }
    return(RET);
}

/*
 *  decode = proc(ist: istream) returns(string)
 *			      signals(end_of_file, not_possible(string))
 *	modifies  ist.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 */

int string_decode(istream ist)
{
    int sz, i;
    string s;

    if (istream_geti(ist) == SIG) {
	return(SIG);
    }
    sz = (int) retval_area[0];
    if (sz < 0) {
	signame = "not_possible";
	sigarg_area[0] = (elt) "bad format";
	return(SIG);
    }
    s = (string) malloc_atomic((sz + 1) * sizeof(char));
    for (i = 0; i < sz; i++) {
	if (istream_getc(ist) == SIG) {
	    return(SIG);
	}
	s[i] = (char) retval_area[0];
    }
    s[sz] = '\0';
    retval_area[0] = (elt) s;
    return(RET);
}

/* 
 * _gcd = proc(s: string, tab: gcd_tab) returns(int)
 */

int string__gcd(string s, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "string$_gcd: not implemented";
    return(SIG);
}
