/*
 * $Id: rename_file.c,v 2.0 1992/09/23 08:44:26 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* rename_file = proc(oldfn, newfn: file_name) signals(not_possible(string))
 *	% Renames oldfn as newfn. 
 * 	end rename_file
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

extern char* sys_errlist[];
extern int errno;

int _prename_file(clus oldfn, clus newfn)
{
    int except_level;
    string oldname, newname;

    /*
     *	begin body
     */

    except_level = 0;

    /* oldfn := file_name_fill(oldfn, "") */
    if (_pfile_name_fill(oldfn, "") == SIG)
	goto sighandler;
    oldfn = (clus) retval_area[0];

    /* oldname: string := file_name$unparse(oldfn) */
    if (file_name_unparse(oldfn) == SIG)
	goto sighandler;
    oldname = (string) retval_area[0];

    /* newfn := file_name_fill(newfn, "") */
    if (_pfile_name_fill(newfn, "") == SIG)
	goto sighandler;
    newfn = (clus) retval_area[0];

    /* newname: string := file_name$unparse(newfn) */
    if (file_name_unparse(newfn) == SIG)
	goto sighandler;
    newname = (string) retval_area[0];

    if (rename(oldname, newname) < 0) {
	/* signal not_possible(...) */
	sigarg_area[0] = (elt) sys_errlist[errno];
	signame = "not_possible";
	return SIG;
    }

    return RET;

    /*
     *	end body
     */

    /*
     *	signal handler (exception hadler)
     */

 sighandler:
    switch (except_level) {
    case -1:
	string_concat("unhandle exception: ", signame);
	sigarg_area[0] = retval_area[0];
	signame = "failure";
	return (SIG);
    case 0:
	if (!strcmp(signame, "failure"))
	    return (SIG);
	else {
	    string_concat("unhandle exception: ", signame);
	    sigarg_area[0] = retval_area[0];
	    signame = "failure";
	    return (SIG);
	}
    }
}
