/* 
 * $Id: record.c,v 2.0 1992/09/23 08:44:10 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

/*
 * get_Ni = proc(record[N1:T1,...,Nn:Tn])returns(Ti)
 */

int record_get(int i, record r)
{
  retval_area[0] = r[i];
  return(RET);
}

/*
 * set_Ni = proc(record[N1:T1,...,Nn:Tn],Ti)
 */

int record_set(int i, record r,elt e)
{
  r[i] = e;
  return(RET);
}

/*
 * r_gets_r = proc(record[N1:T1,...,Nn:Tn],record[N1:T1,...,Nn:Tn])
 */

int record_r_gets_r(record r1, record r2)
{
  int sz, i;

  sz  = r2[0];
  for(i = 1; i < sz; i++)
    r1[i] = r2[i];
  return(RET);
}

/*
 * r_gets_s = proc(record[N1:T1,...,Nn:Tn],struct[N1:T1,...,Nn:Tn])
 */

int record_r_gets_s(record r, struct_ s)
{
  int sz, i;

  sz = r[0];
  for(i = 1; i < sz; i++)
    r[i] = s[i];
  return(RET);
}

/*
 * equal = proc(record[N1:T1,...,Nn:Tn],record([N1:T1,...,Nn:Tn])returns(bool)
 */

int record_equal(record r1, record r2)
{
  retval_area[0] = (r1 == r2);
  return(RET);
}

/*
 * copy1 = proc(record[N1:T1,...,Nn:Tn])returns([N1:T1,...,Nn:Tn])
 */

int record_copy1(record r1)
{
  int sz,i;
  record new_rec;

  sz = r1[0];
  new_rec = (record) malloc(sz*sizeof(elt));  /* alloc new record */
  for(i = 0; i < sz; i++)
    new_rec[i] = r1[i];
  retval_area[0] = (elt) new_rec;
  return(RET);
}

/*
 * print = proc(r: record[n1: t1, ... nn: tn], pst: pstream)
 *	where each ti has print: proctype(ti, pstream)
 */

int record_print(int (*(op_list[]))(), record r, clus pst)
{
    int i;

    if ( _cpstream_start(pst, "{") == SIG ) {
	out_handler();
	return SIG;
    }
    for ( i = 1; i < r[0]; i++ ) {
	if ( i > 1 ) {
	    if ( _cpstream_pause(pst, ", ") == SIG ) {
		out_handler();
		return SIG;
	    }
	    bool_not((bool) retval_area[0]);
	    if ( (bool) retval_area[0] ) {
		break;
	    }
	}
	(*(op_list[i - 1]))(r[i], pst);	 	/* invoke ti$print */
    }
    if ( _cpstream_stop(pst, "}") == SIG ) {
	out_handler();
	return SIG;
    }
    return RET;
}

/*
 * _gcd = proc (r: record[n1: t1, ... nn: tn], tab: gcd_tab) returns(int)
 *	where each ti has _gcd: proctype(it, gcd_tab) returns(int)
 */

int record__gcd(int (*(op_list[]))(), record r, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "record$_gcd: not implemented";
    return SIG;
}
