/* 
 * $Id: oneof.c,v 2.0 1992/09/23 08:43:14 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

/*
 * make_Ni = proc(Ti)returns(oneof[N1:T1,...,Nn:Tn])
 */

int oneof_make(int tag, elt e)
{
  oneof one;

  one = (oneof) malloc(sizeof(struct oneof_rep));
  one->tag = tag;
  one->value = e;
  retval_area[0] = (elt) one;
  return(RET);
}

/*
 * is_Ni = proc(oneof[N1:T1,...,Nn:Tn])returns(bool)
 */

int oneof_is_(int tag, oneof one)
{
  retval_area[0] = (one->tag == tag) ? TRUE : FALSE;
  return(RET);
}

/*
 * value_Ni = proc(oneof[N1:T1,...,Nn:Tn])returns(Ti)signals(wrong_tag)
 */

int oneof_value(int tag, oneof one)
{
  if (one->tag == tag) {
    retval_area[0] = (elt) one->value;
    return(RET);
  }
  else {
    signame = "wrong_tag";
    return(SIG);
  }
}

/*
 * o2v = proc(oneof[N1:T1,...,Nn:Tn])returns(variant[N1:T1,...,Nn:Tn])
 */

int oneof_o2v(oneof one)
{
  variant var;

  var = (variant) malloc(sizeof(struct variant_rep));
  var->tag = one->tag;
  var->value = one->value;
  retval_area[0] = (elt) var;
  return(RET);
}

/*
 * o2v = proc(variant[N1:T1,...,Nn:Tn])returns(oneof[N1:T1,...,Nn:Tn])
 */

int oneof_v2o(variant var)
{
  oneof one;

  one = (oneof) malloc(sizeof(struct oneof_rep));
  one->tag = var->tag;
  one->value = var->value;
  retval_area[0] = (elt) one;
  return(RET);
}

/*
 * print = proc(o: oneof[n1: t1, ..., nn: tn], pst: pstream)
 *	where each ti has print: proctype(ti, pstream)
 */

int oneof_print(int (*(op_list[]))(), oneof o, clus pst)
{
    if ( _cpstream_start(pst, "<") == SIG ) {
	out_handler();
	return SIG;
    }
    if ( int_print(o->tag, pst) == SIG ) {
	out_handler();
	return SIG;
    }
    if ( _cpstream_text(pst, ": ") == SIG ) {
	out_handler();
	return SIG;
    }
    if ( (*(op_list[o->tag - 1]))(o->value, pst) == SIG ) {
	out_handler();
	return SIG;
    }	
    if ( _cpstream_stop(pst, ">") == SIG ) {
	out_handler();
	return SIG;
    }
    return RET;
}

/*
 * _gcd = proc(o: oneof[n1: t1, ..., nn: tn], tab: gcd_tab) returns(int)
 *	where each ti has _gcd: proctype(ti, gcd_tab) returns(int)
 */

int oneof__gcd(int (*(op_list[]))(), oneof o, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "oneof$_gcd: not implemented";
    return SIG;
}
