/* 
 * $Id: int.c,v 2.0 1992/09/23 08:41:26 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* fully implemented */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

#include <stdio.h>
#include <math.h>
#include <string.h>

#define MAX_NUM_LEN 30

/* overflow, underflow is ignored */
/* add, sub, mul, minus, cmp -> odinary inline  */

/*
 * add = proc(int,int)returns(int)signals(overflow)
 */

int int_add(int x, int y)
{
  retval_area[0] = x + y;
  return(RET);
}

/*
 * sub = proc(int,int)returns(int)signals(overflow)
 */

int int_sub(int x, int y)
{
  retval_area[0] = x - y;
  return(RET);
}

/*
 * mul = proc(int,int)returns(int)signals(overflow)
 */

int int_mul(int x, int y)
{
  retval_area[0] = x * y;
  return(RET);
}

/*
 * minus = proc(int)returns(int)signals(overflow,underflow)
 */

int int_minus(int x)
{
  retval_area[0] = - x;
  return(RET);
}

/*
 * div = proc(int,int)returns(int)signals(overflow)
 *
 * Note that the behavior of C's division operator is underspecified
 * when ether or both of the operands are negative.
 *
 */

int int_div(int x, int y)
{
  int sign, yabs;

  if(y == 0)
  {
    signame = "zero_divide";
    return(SIG);
  }
  sign = y > 0 ? 1 : -1;
  if (x >= 0) {
    retval_area[0] = (x / abs(y)) * sign;
  }
  else {
    yabs = abs(y);
    retval_area[0] = ((-x + yabs - 1) / yabs) * (-sign);
  }
  return(RET);
}

/*
 * mod = proc(int,int)returns(int)signals(zero_divide,overflow)
 *
 * Note that the behavior of C's modulo operator is underspecified
 * when ether or both of the operands are negative.
 *
 */

int int_mod(int x, int y)
{
  int yabs;

  if(y == 0)
  {
    signame = "zero_divide";
    return(SIG);
  }
  if (x >= 0) {
    retval_area[0] = x % abs(y);
  }
  else {
    yabs = abs(y);
    x = yabs - ((-x) % yabs);
    retval_area[0] = (x == yabs) ? 0 : x;
  }
  return(RET);
}

/*
 * power = proc(int,int)returns(int)signals(negative_exponent,overflow)
 */

int int_power(int x, int y)			/* overfolw is ignore */
{
  int res, i;
  
  if (y < 0) {
  	signame = "negative_exponent";
  	return(SIG);
  }
  else if (y == 0) {
  	retval_area[0] = 1;
  }
  else if (x == 0) {
  	retval_area[0] = 0;
  }
  else
  {
    res = x;
    for (i = 1; i < y; i ++)
     res *= x;
    retval_area[0] = (int) res;
  }
  return(RET);
}
  
/*
 * abs = proc(int)returns(int)signals(overflow)
 */

int int_abs(int x)
{
  retval_area[0] = (elt) (x > 0) ? x : -x;
  return(RET);
}

/*
 * max = proc(int,int)returns(int)
 */

int int_max(int x, int y)
{
  retval_area[0] = (elt) (x > y) ? x : y;
  return(RET);
}

/*
 * min = proc(int,int)returns(int)
 */

int int_min(int x, int y)
{
  retval_area[0] = (elt) (x < y) ? x : y;
  return(RET);
}

/*
 * from_to_by = iter(int,int,int)yields(int)
 */

int int_from_to_by(bool init, elt** ivarp, int f,int t, int b)
{

  if (init) {               /* initial iterator call */
    /*
     *	Because an object being allocated doesn't contain any pointer,
     *	malloc_atomic is used rather than malloc, expecting better efficiency.
     */
    *ivarp = (int*) malloc_atomic((1+3)*sizeof(int));
    (*ivarp)[1] = f;
    (*ivarp)[2] = t;
    (*ivarp)[3] = b;
  }
  else                     /* not initial call, goto previous yield point */
    if ((*ivarp)[0] == 1) goto yield1;

  while (TRUE) {
    if ((*ivarp)[3] > 0 && (*ivarp)[1] > (*ivarp)[2])
      break;
    if ((*ivarp)[3] < 0 && (*ivarp)[1] < (*ivarp)[2])
      break;
    retval_area[0] = (elt) (*ivarp)[1];
    (*ivarp)[0] = 1;
    return(RET);
  yield1:
    (*ivarp)[1] += (*ivarp)[3];
  }
  iter_end = TRUE;
  return(RET); 
}

/*
 * from_to = iter(int,int)yields(int)
 */

int int_from_to(bool init, elt** ivarp, int f,int t)
{

  if (init) {               /* initial iterator call */
    /*
     *	Because an object being allocated doesn't contain any pointer,
     *	malloc_atomic is used rather than malloc, expecting better efficiency.
     */
    *ivarp = (int*) malloc_atomic((1+2)*sizeof(int));
    (*ivarp)[1] = f;
    (*ivarp)[2] = t;
  }
  else                     /* not initial call, goto previous yield point */
    if ((*ivarp)[0] == 1) goto yield1;

  while ((*ivarp)[1] <= (*ivarp)[2]) {
    retval_area[0] = (elt) (*ivarp)[1];
    (*ivarp)[0] = 1;
    return(RET);
  yield1:
    (*ivarp)[1]++;
  }
  iter_end = TRUE;
  return(RET);
}

/*
 * parse = proc(string)returns(int)signals(bad_format,overflow)
 */

int int_parse(string s)			/* overflow is ignore */
{
  int i = 0, size;
  char c;

  size = strlen(s);
  if (size == 0) {                      /* when containing no char */
      signame = "bad_format";
      return(SIG);
    }

  c = s[i];
  if (c == '+' || c == '-')             /* when the first char is sign */
    if (size == 1) {
      signame = "bad_format";
      return(SIG);
    }
    else
      i++;

  for(; i < size; i++) {                /* check each element */
    c = s[i];
    if (c < '0' || c > '9') {
      signame = "bad_format";
      return(SIG);
    }
  }
  retval_area[0] = (elt) atoi(s);             /* convert to integer */
  return(RET);
}

/*
 * unparse = proc(int)returns(string)
 */

int int_unparse(int x)
{
  char s[MAX_NUM_LEN];
  string res;
  int length;
  
  sprintf(s, "%d", x);
  length = strlen(s);
  /*
   *	Because an object being allocated doesn't contain any pointer,
   *	malloc_atomic is used rather than malloc, expecting better efficiency.
   */
  res = (string) malloc_atomic(length + 1);
  strcpy(res, s);
  retval_area[0] = (elt) res;
  return(RET);
}

/*
 * lt = proc(int,int)returns(bool)
 */

int int_lt(int x, int y)
{
  retval_area[0] = (x < y);
  return(RET);
}

/*
 * le = proc(int,int)returns(bool)
 */

int int_le(int x, int y)
{
  retval_area[0] = (x <= y);
  return(RET);
}

/*
 * ge = proc(int,int)returns(bool)
 */

int int_ge(int x, int y)
{
  retval_area[0] = (x >= y);
  return(RET);
}

/*
 * gt = proc(int,int)returns(bool)
 */

int int_gt(int x, int y)
{
  retval_area[0] = (x > y);
  return(RET);
}

/*
 * equal = proc(int,int)returns(bool)
 */

int int_equal(int x, int y)
{
  retval_area[0] = (x == y);
  return(RET);
}

/*
 * similar = proc(int,int)returns(bool)
 */

int int_similar(int x, int y)
{
  retval_area[0] = (x == y);
  return(RET);
}

/*
 * copy = proc(int,int)returns(bool)
 */

int int_copy(int i)
{
  retval_area[0] = (elt) i;
  return(RET);
}

/*
 * print = proc(i: int, pst: pstream)
 */

int int_print(int i, clus pst)
{
    int_unparse(i);
    if ( _cpstream_text(pst, retval_area[0]) == SIG ) {
	out_handler();
	return(SIG);
    }
    return(RET);
}

/*
 *  encode = proc(i: int, s: istream) signals(not_possible(string))
 *	modifies  s.
 *	effects  Writes an encoding of i onto the istream s.
 */

int int_encode(int i, istream s)
{
    return(istream_puti(s, i));
}

/*
 *  decode = proc(s: istream) returns(int)
 *			      signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 */

int int_decode(istream s)
{
    return(istream_geti(s));
}

/*
 * _gcd = proc(i: int, tab: gcd_tab) returns(int)
 */

int int__gcd(int i, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "int$_gcd: not implemented";
    return(SIG);
}
