/*
 * $Id: _home_dir.c,v 2.0 1992/09/23 08:38:16 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

static char rcsid[] = "$Id: _home_dir.c,v 2.0 1992/09/23 08:38:16 toh-hei Exp $";

/* working */

#include <clu2c.h>
#include <type.h>
#include <glo.h>
#include <sys/param.h>
#include <pwd.h>

/*
 * _home_dir = proc(string)returns(string)signal(not_possible(string))
 */

_p_home_dir(string username)
{
  struct passwd* pw;
  char* s,s1;
  char* n = (char*)username;
  if(!strcmp(n,"CLU")) {
    /*
     *	Because an object being allocated doesn't contain any pointer,
     *	malloc_atomic is used rather than malloc, expecting better efficiency.
     */
    s = (char*)malloc_atomic(sizeof(char)*(strlen("/usr/clu")+1));
    strcpy(s,"/usr/clu");
  } else {
    if(!strlen(n))
      pw = getpwuid(getuid());
    else
      if((int)(pw = getpwnam(n)) == 0) {
	SIGNAL1("failure", "_home_dir: not_found");
      }
    /*
     *	Because an object being allocated doesn't contain any pointer,
     *	malloc_atomic is used rather than malloc, expecting better efficiency.
     */
    s = (char*)malloc_atomic(sizeof(char)*(strlen(pw->pw_dir)+1));
    strcpy(s,pw->pw_dir);
  }
  RETURN1(s);
}
