#!/bin/sh
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
MAKE      = make
LIBDIR    = $libdir
ARCHIVES  = libgc.a libclu2c.a libcmp.a
MISCFILES = basic.types clu.order system.names

all: \$(ARCHIVES)

libgc.a:
	(cd gc; $(MAKE) $(MFLAGS))

libclu2c.a:
	(cd blt-in; $(MAKE) $(MFLAGS))

libcmp.a:
	(cd cmp; $(MAKE) $(MFLAGS))

install: \$(ARCHIVES) \$(MISCFILES) \$(LIBDIR)
	(cd \$(LIBDIR); rm -f \$(ARCHIVES) \$(MISCFILES))
	cp \$(ARCHIVES) \$(MISCFILES) \$(LIBDIR) 

\$(LIBDIR):
	mkdir \$(LIBDIR)
	chmod 755 \$(LIBDIR)

clean:
	(cd gc; $(MAKE) $(MFLAGS) clean)
	(cd blt-in; $(MAKE) $(MFLAGS) clean)
	(cd cmp; $(MAKE) $(MFLAGS) clean)
EOF
echo ' done'
