/*
 * $Id: real.h,v 2.0 1992/09/23 12:25:53 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All rights reserved.
 *
 */

#ifndef _REAL_
#define _REAL_

/* Representation */

typedef int real;

/* Tricks for converting float into int and vice versa */

static union {
    int i;
    float f;
} conv;

#define f2i(x) (conv.f=(x),conv.i)
#define i2f(x) (conv.i=(x),conv.f)

/* Macros for inline expansion */

/* 
 * Currently the following macros don't work as expected.  DON'T USE.
 */

#define _real_add(x,y)		f2i(i2f(x) + i2f(y))
#define _real_sub(x,y)		f2i(i2f(x) - i2f(y))
#define _real_mul(x,y)		f2i(i2f(x) * i2f(y))
#define _real_minus(x)		f2i(-i2f(x))
#define _real_abs(x)		f2i((float) fabs(i2f(x)))
#define _real_i2r(x)		f2i((float) (x))
#define _real_r2i(x)		((int) i2f(x))		/* !!! */
#define _real_trunc(x)		((int) i2f(x))
#define _real_lt(x,y)		(i2f(x) <  i2f(y))
#define _real_le(x,y)		(i2f(x) <= i2f(y))
#define _real_ge(x,y)		(i2f(x) >= i2f(y))
#define _real_gt(x,y)		(i2f(x) >  i2f(y))
#define _real_equal(x,y)	((x) == (y))
#define _real_similar(x,y)	((x) == (y))
#define _real_copy(x)		(x)

#endif /* _REAL_ */
