#!/bin/sh
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
BLTINDIR = $incdir/blt-in
BLTIN    = any.h array.h bool.h char.h file_name.h int.h istream.h\
	 itertype.h null.h oneof.h proctype.h real.h record.h\
	 sequence.h stream.h string.h struct.h variant.h wvec.h


install: \$(BLTIN) \$(BLTINDIR)
	@echo -n 'Installing header files ...'
	@(cd \$(BLTINDIR); rm -f \$(BLTIN))
	@cp \$(BLTIN) \$(BLTINDIR)
	@echo ' done'

\$(BLTINDIR):
	mkdir \$(BLTINDIR)
	chmod 755 \$(BLTINDIR)
EOF
echo ' done'
