#!/bin/sh
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
TMPBINDIR = ../../bin
TMPINCDIR = ../../include
TMPLIBDIR = ../../lib
PLINK     = \$(TMPBINDIR)/plink
CC        = $cc
CFLAGS    = $cflags -I\$(TMPINCDIR) -w
BINDIR    = $bindir
CLU2C     = clu2c
OPTABLEC  = op-table.c
OPTABLEO  = op-table.o
OBJ       =\\
	build.o\\
	cconst.o\\
	cdefn1.o\\
	cdefn2.o\\
	ce.o\\
	cenv.o\\
	cexpr1.o\\
	cexpr2.o\\
	cmpvar.o\\
	coper.o\\
	cspecs.o\\
	cstmt1.o\\
	cstmt2.o\\
	debug.o\\
	du.o\\
	dusimilar.o\\
	eval1.o\\
	eval2.o\\
	gcons.o\\
	gctrl.o\\
	genv.o\\
	gexcept.o\\
	gexpr.o\\
	ginvoke.o\\
	glit.o\\
	gname.o\\
	goptimize.o\\
	gparam.o\\
	gstmt.o\\
	gtop.o\\
	idn.o\\
	init.o\\
	menv.o\\
	make.o\\
	mcmp.o\\
	plist.o\\
	pconst.o\\
	pdefn1.o\\
	pdefn2.o\\
	penv.o\\
	pexpr.o\\
	pjcl.o\\
	pstmt1.o\\
	pstmt2.o\\
	pttkn.o\\
	syntax.o\\
	table.o\\
	tkntab.o\\
	top1.o\\
	top2.o\\
	vcmp.o\\
	xlib.o\\
	xref.o

all: \$(CLU2C)
	cp \$(CLU2C) \$(TMPBINDIR)

\$(CLU2C): \$(OBJ) 
	-\$(PLINK) \$(OBJ)
	\$(CC) \$(CFLAGS) \$\$parmdefs \$(OBJ) \$(OPTABLEC)\\
		-L\$(TMPLIBDIR) -lcmp -lclu2c -lgc -lm -o \$(CLU2C)

install: \$(CLU2C) \$(BINDIR)
	@echo -n 'Installing' \$(CLU2C) '...'
	@install -c \$(CLU2C) \$(BINDIR)
	@echo -n ' done'

\$(BINDIR):
	mkdir \$(BINDIR)
	chmod 755 \$(BINDIR)

clean:
	rm -f \$(OBJ) \$(CLU2C) \$(TMPBINDIR)/\$(CLU2C) \$(OPTABLEC) \$(OPTABLEO)
EOF
echo ' done'
