/*
 * snacc_util.h
 *
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */


/*
 * macro to allocate room for str & null & put in give STR*
 */
#define SETUP_STR( strPtr, string)\
    (strPtr)->str = Malloc(strlen(string) + 1);\
    strcpy((strPtr)->str, string);\
    (strPtr)->len = strlen(string) + 1


/*
 * Create a new list type such that each elmt has space
 * to hold a pointer
 */
#define NEWLIST()  GListNew(sizeof(void*))

/*
 *    macro to append an element to the end of linked list
 *    - helps on left recursion when order must be maintained
 *
 *  be careful of calling context if list is null
 *  that is, make sure the change to list is not lost.
 */
#define APPEND( elmt, list) \
{\
    void** tmpPtr;\
    if ((list) == NULL)\
        (list) = NEWLIST();\
    tmpPtr = (void**) GListAppend((GLIST*)list);\
    *tmpPtr = (void*) (elmt);\
}

/*
 * like APPEND except puts elmt at head of  list
 */
#define PREPEND( elmt, list) \
{\
    void** tmpPtr;\
    if ((list) == NULL)\
        (list) = NEWLIST();\
    tmpPtr = (void**)GListPrepend((GLIST*)list);\
    *tmpPtr = (void*) (elmt);\
}

void SetupType PROTO(( Type** t, enum BasicTypeChoiceId typeId,
                      unsigned long lineNum));

void SetupMacroType PROTO(( Type** t, enum MacroTypeChoiceId macroTypeId,
                           unsigned long lineNum));

void SetupValue PROTO(( Value** v, enum BasicValueChoiceId valId,
                       unsigned long lineNum));

ImportElmt* LookupImportElmtInModule PROTO((Module* m, char* name,
                                            ImportModule** importModule));

ImportElmt* LookupImportElmtInImportElmtList PROTO(( ImportElmtList* importElmtList, char* name));

ImportModule* LookupImportModule PROTO((Module* m, char* importModuleName));

TypeDef* LookupType PROTO(( TypeDefList* t, char* typeName));

Module* LookupModule PROTO(( ModuleList* m, char* modName, OID* oid));

NamedType* LookupFieldInType PROTO((Type* t, char* fieldName));

Type* GetType PROTO(( Type* t));

Type* ParanoidGetType PROTO(( Type* t));

enum BasicTypeChoiceId GetBuiltinType PROTO(( Type* t));

NamedNumberList* GetNamedElmts PROTO((Type* t));

Type* GetParent PROTO((Type* ancestor, Type* child));

ValueDef* LookupValue PROTO(( ValueDefList* v, char* valueName));

Value* GetValue PROTO(( Value* v));

int CompareOids PROTO(( OID* oid1, OID* oid2));

int HasNamedElmts PROTO((Type* t));

int TagsAreIdentical PROTO((TagList* t1, TagList* t2));

int HasDefaultTag PROTO((Type* t));

int IsPrimitiveByDefOrRef PROTO(( Type* t));

int IsPrimitiveByDef PROTO(( Type* t));

int IsDefinedByLibraryType PROTO(( Type* t));

int IsTypeRef PROTO((Type* t));

int IsNewType PROTO((Type* t));

int IsTailOptional PROTO((NamedTypeList* e));

int NextIsTailOptional PROTO((NamedTypeList* e));

int AllElmtsOptional PROTO((NamedTypeList* e));

AnyRefList** GetAnyRefListHndl PROTO((Type* t));

void AppendSubtype PROTO((Subtype** s, Subtype* newSubtype,
                          enum SubtypeChoiceId op));
