/*
 * snacc_config.h - configures the ANSI/non ansi, defines 
 *            and other stuff
 * MS 91/92
 *
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

/* 
 * Define  __USE_ANSI_C__ if your compiler is ANSI
 */
#define __USE_ANSI_C__


  /* malloc type */
#define MT(type) (type*)Malloc(sizeof(type));  

#define PrintErrLoc(fileName, lineNo)\
   fprintf(stderr,"file \"%s\", line %d : ", fileName, lineNo)


#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


#ifndef NULL
#define NULL 0
#endif


/*
 *  Inspired by gdb 4.0, for better or worse...
 *  (grabbed from Barry Brachman - MS)
 * 
 *  These macros munge C routine declarations such
 *  that they work for ANSI or non-ANSI C compilers
 */
#ifdef __USE_ANSI_C__

#define PROTO(X)			X
#define PARAMS(arglist, args)  		(args)
#define NOPARAMS()	        	(void)
#define _AND_				,
#define DOTS				, ...

#else

#define PROTO(X)			()
#define PARAMS(arglist, args)	 	arglist args;
#define NOPARAMS()	        	()
#define _AND_				;
#define DOTS
#define void                            char

#endif
