/*
 * list.h 
 *
 *  ---------
 *  | GLIST |
 *  |  last |-------------------------------------------|
 *  |  curr |--------------------------|                |
 *  |  first|--------|                 |                |
 *  ---------        |                 |                |
 *                   V                 V                V
 *                ---------        ---------        ---------
 *                |GLISTNODE       |GLISTNODE       |GLISTNODE
 *                | next  |---...->|  next |--...-->| next  |-----|i.
 *         .i|----| prev  |<--...--|  prev |<--...--| prev  |
 *                | data  |        |  data |        | data  |     
 *                ---------        ---------        ---------
 *
 * Copyright (C) 1991, 1992  the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

typedef struct GLISTNODE
{
    struct GLISTNODE *prev;
    struct GLISTNODE *next;
    void            *data; /* this must be the last field of this structure  */
} GLISTNODE;

typedef struct
{
    GLISTNODE *first;
    GLISTNODE *last;
    GLISTNODE *curr;
    int        count;    /* number of elements in list               */
    int        dataSize; /* space required in each node for the data */
} GLIST;


#define  FOR_EACH_LIST_ELMT( elmt,  glist)\
if ((glist) != NULL)\
    for ((glist)->curr = (glist)->first;\
         ((glist)->curr != NULL) && (((elmt) =(void*)((glist)->curr->data)) != NULL);\
         (glist)->curr = (glist)->curr->next )

#define  FOR_EACH_LIST_ELMT_RVS( elmt,  glist)\
if ((glist) != NULL)\
    for ((glist)->curr = (glist)->last;\
         (((glist)->curr != NULL)) && (((elmt) =(void*)(glist)->curr->data) != NULL);\
         (glist)->curr = (glist)->curr->prev )


#define  FOR_REST_LIST_ELMT( elmt,  glist)\
if ((glist) != NULL)\
  for (; (((glist)->curr != NULL)) && (((elmt) = (void*)(glist)->curr->data) != NULL);\
         (glist)->curr = (glist)->curr->next )

/*
 * The following macros return the pointer stored in the 
 * data part of the listNode.  The do not change the current
 * list pointer.
 */
#define CURR_LIST_ELMT(glist)    (glist)->curr->data
#define NEXT_LIST_ELMT(glist)    (glist)->curr->next->data
#define PREV_LIST_ELMT(glist)    (glist)->curr->prev->data
#define LAST_LIST_ELMT(glist)    (glist)->last->data
#define FIRST_LIST_ELMT(glist)   (glist)->first->data
#define LIST_EMPTY(glist)        ((glist)->count == 0)
#define LIST_COUNT(glist)        ((glist)->count)


/*
 * list nodes are the parts of the list that contain ptrs/data
 * to/of the list elmts.
 */
#define CURR_LIST_NODE(glist) ((glist)->curr)
#define FIRST_LIST_NODE(glist)((glist)->first)
#define LAST_LIST_NODE(glist) ((glist)->last)
#define PREV_LIST_NODE(glist) ((glist)->curr->prev)
#define NEXT_LIST_NODE(glist) ((glist)->curr->next)
#define SET_CURR_LIST_NODE(glist, listNode)  ((glist)->curr = (GLISTNODE*) (listNode))


void  GListFree PROTO(( GLIST* ));
void  GListRemove PROTO(( GLIST* ));
void  *GListAdd PROTO(( GLIST* ));
void  *GListInsert PROTO(( GLIST* ));
GLIST *GListNew PROTO(( int ));
void  *GListPrev PROTO(( GLIST* ));
void  *GListNext PROTO(( GLIST* ));
void  *GListLast PROTO(( GLIST* ));
void  *GListFirst PROTO(( GLIST* ));
void  *GListPrepend PROTO(( GLIST* ));
void  *GListAppend PROTO(( GLIST* ));
void  *GListCurr PROTO(( GLIST*));
int   GListCount PROTO(( GLIST* ));
GLIST* GListConcat PROTO((GLIST*, GLIST*));
long int GetGListElmtIndex PROTO((void* elmt,GLIST* list));


