/*
 * lib_types.h 
 *
 * Copyright (C) 1991, 1992 Michael Sample
 *            and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */


typedef struct LibType
{
    enum BasicTypeChoiceId typeId;
    BER_UNIV_CODE          univTagCode;
    BER_FORM               tagForm;
    AnyRefList*            anyRefs;  /* these may be filled in do_macros.c*/
}  LibType;


extern LibType libTypesG[];

#define LIBTYPE_GET_UNIV_TAG_CODE(tId) (libTypesG[tId].univTagCode)
#define LIBTYPE_GET_TAG_FORM(tId)      (libTypesG[tId].tagForm)
#define LIBTYPE_GET_ANY_REFS(tId)      (libTypesG[tId].anyRefs)
#define LIBTYPE_GET_ANY_REFS_HNDL(tId) (&libTypesG[tId].anyRefs)
#define LIBTYPE_GET_ANY_REFS(tId)      (libTypesG[tId].anyRefs)
