/* 
 * define.h 
 *
 * Copyright (C) 1991, 1992 Michael Sample
 *            and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */


typedef struct DefinedObj
{
    void* obj;
    struct DefinedObj* next;
} DefinedObj;


typedef int (*CmpObjsRoutine) PROTO((void* obj1, void* obj2));
typedef int (*FreeObjRoutine) PROTO((void* obj));

int StrObjCmp PROTO((void* s1, void* s2));

int IntObjCmp PROTO((void* s1, void* s2));

int OidObjCmp PROTO((void* o1, void* o2));

int ObjPtrCmp PROTO((void* s1, void* s2));

DefinedObj*  NewObjList();

void DefineObj PROTO((DefinedObj** l, void* obj));

void UndefineObj PROTO((DefinedObj** l, void* obj, CmpObjsRoutine cmpRoutine));

int  ObjIsDefined PROTO((DefinedObj* l, void* obj, CmpObjsRoutine cmp));

void FreeDefinedObjs PROTO((DefinedObj** l));

void FreeDefinedObjsAndContent PROTO((DefinedObj** l));
