/*
 * cpp_kwd.c - routines for determining whether a given str is a C++
 *             keyword
 *
 *    NOTE: this was hacked up really quickly.  It uses a slow linear
 *          search. A much better approach is to use a hash tbl.
 * 
 * MS 92
 * Copyright (C) 1991, 1992 Michael Sample
 *            and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

#include <string.h>
#include "snacc_config.h"

/*
 * last elmt will be NULL.
 * key words grabbed from C++/Stroustrup 2.0 
 */
static char* cppKWdG[] =
{
    "asm", "auto", "break", "case", "catch", "char", "class",
    "const", "continue", "default", "delete", "do", "double",
    "else", "enum", "extern", "float", "for", "friend", "goto",
    "if", "inline", "int", "long", "new", "operator", "private",
    "protected", "public", "register", "return", "short", "signed",
    "sizeof", "static", "struct", "switch", "template", "this",
    "throw", "try", "typedef", "union", "unsigned", "virtual",
    "void", "volatile", "while", NULL
};


/*
 * returns non-zero if the given str is a C++ key word
 */
int
IsCppKeyWord PARAMS((str),
char* str)
{
    int i;

    for (i=0; (cppKWdG[i] != NULL) && (strcmp(cppKWdG[i],str) != 0); i++);

    return(cppKWdG[i] != NULL);
}


