/*
 * gen_cpp_vals.c - prints ASN.1 values in Cpp format
 *
 * MS 92
 * Copyright (C) 1991, 1992 Michael Sample 
 *           and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 */

#include <stdio.h>
#include "snacc_config.h"
#include "basetypes.h"
#include "ber.h"
#include "list.h"
#include "oid.h"
#include "asn1module.h"
#include "mem.h"
#include "define.h"
#include "typetbl.h"
#include "rules.h"
#include "type_info.h"
#include "str_util.h"
#include "snacc_util.h"
#include "util.h"
#include "cpp_rules.h"
#include "gen_cpp_vals.h"

/* non-exported routines' prototypes */

static void PrintCppValueDefsName PROTO((FILE* f, CppRules* r, ValueDef* v));




void
PrintCppValueDef PARAMS((src, r, v),
FILE* src _AND_
CppRules* r _AND_
ValueDef* v)
{
    /* just do oid's, ints and bools for now */
    if ((v->value->basicValue->choiceId != BASICVALUE_OID) &&
        (v->value->basicValue->choiceId != BASICVALUE_INTEGER) &&
        (v->value->basicValue->choiceId != BASICVALUE_BOOLEAN))
        return;

    /*
     * put instantiation in src file
     */
    fprintf(src,"const ");
    PrintCppValuesClass(src, r, v->value);
    fprintf(src," ");
    PrintCppValueDefsName(src, r, v);
    PrintCppValueInstatiation(src, r, v->value);
    fprintf(src,";\n\n");


}  /* PrintCppValueDef */

void
PrintCppValueExtern PARAMS(( hdr, r, v),
FILE* hdr _AND_
CppRules* r _AND_
ValueDef* v)
{
    /* just do oid's, ints and bools for now */
    if ((v->value->basicValue->choiceId != BASICVALUE_OID) &&
        (v->value->basicValue->choiceId != BASICVALUE_INTEGER) &&
        (v->value->basicValue->choiceId != BASICVALUE_BOOLEAN))
        return;

    /*
     * put extern declaration in hdr file
     */
    fprintf(hdr,"extern const ");
    PrintCppValuesClass(hdr, r, v->value);
    fprintf(hdr," ");
    PrintCppValueDefsName(hdr, r, v);
    fprintf(hdr,";\n");

}  /* PrintCppValueExtern */


static void
PrintCppValueDefsName PARAMS((f, r, v),
FILE* f _AND_
CppRules* r _AND_
ValueDef* v)
{
    char* cName;
    cName = Asn1ValueName2CValueName(v->definedName);
    fprintf(f, "%s", cName);
    Free(cName);
}

void
PrintCppValuesClass PARAMS((f, r, v),
FILE* f _AND_
CppRules* r _AND_
Value* v)
{
    /* needs work - just do ints bools and oid's for now */
    switch (v->basicValue->choiceId)
    {
        case(BASICVALUE_OID):
            fprintf(f, "%s", r->typeConvTbl[BASICTYPE_OID].className);
            break;

        case(BASICVALUE_INTEGER):
            fprintf(f, "%s", r->typeConvTbl[BASICTYPE_INTEGER].className);
            break;

        case(BASICVALUE_BOOLEAN):
            fprintf(f, "%s", r->typeConvTbl[BASICTYPE_BOOLEAN].className);
            break;

        default:
           break;
    }
}


void
PrintCppValueInstatiation PARAMS((f, r, v),
FILE* f _AND_
CppRules* r _AND_
Value* v)
{
    /* needs work - just do oids, ints and bools for now */
    switch (v->basicValue->choiceId)
    {
        case(BASICVALUE_OID):
            PrintCppOidValue(f, r, v->basicValue->a.oid);
            break;

        case(BASICVALUE_INTEGER):
            PrintCppIntValue(f, r, v->basicValue->a.integer);
            break;

        case(BASICVALUE_BOOLEAN):
            if ( v->basicValue->a.boolean)
                fprintf(f, "(AsnBool::true)");
            else
               fprintf(f, "(AsnBool::false)");
            break;

        default:
           break;
    }
}



/*
 * given an AOID, c++ AOID constructors params are produced.
 * This is used for turning ASN.1 OBJECT ID values
 * into usable c++ values.
 *
 * eg for the oid { 0 1 2 } (in AOID format)
 *   (0,1,2)
 * is produced.
 */
void
PrintCppOidValue PARAMS((f, r, v),
FILE* f _AND_
CppRules* r _AND_
AOID* v)
{
    unsigned short int firstArcNum;
    unsigned long int arcNum;
    int i;

    fprintf(f,"(");

    /* un-munge first two arc numbers */
    for (arcNum = 0, i=0; (i < v->len) && (v->str[i] & 0x80);i++)
        arcNum = (arcNum << 7) + (v->str[i] & 0x7f);

    arcNum = (arcNum << 7) + (v->str[i] & 0x7f);
    i++;
    firstArcNum = arcNum/40;
    if (firstArcNum > 2)
        firstArcNum = 2;

    fprintf(f,"%u, %u", firstArcNum, arcNum - (firstArcNum * 40));

    for (; i < v->len ; )
    {
        for (arcNum = 0; (i < v->len) && (v->str[i] & 0x80);i++)
            arcNum = (arcNum << 7) + (v->str[i] & 0x7f);

        arcNum = (arcNum << 7) + (v->str[i] & 0x7f);
        i++;

        fprintf(f,", %u", arcNum);
    }
    fprintf(f,")");

} /* PrintCppOidValue */



void
PrintCppIntValue PARAMS((f, r, v),
FILE* f _AND_
CppRules* r _AND_
AINT v)
{
    fprintf(f, "(%d)", v);
} /* PrintCppIntValue */
