/*
 *    asn1module.h
 *
 *    "Asn1Module" ASN.1 module C type definitions
 *
 * Copyright (C) 1991, 1992 Michael Sample
 *            and the University of British Columbia
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 *
 *  This contains the data structure for a parsed ASN.1 module
 *  The root of the data structure is the "Module" or "ModuleList"
 *  type.  Understanding this data structure is vital to understanding
 *  how snacc works.
 *
 * Yes, this was generated from an ASN.1 description using a
 * pre-release version snacc.  This was originally motivated by the
 * desire for a file format for parsed modules.  However, snacc does
 * not need to save parsed versions at the moment so the encoders
 * and decoders were left out.  The encoders and decoders needed to be
 * modified a lot since this data structure shares references and 
 * is circularly recursive in many places (ie --> infinite BER values)
 *
 */


#ifndef _asn1module_h_
#define _asn1module_h_


typedef ALIST ModuleList; /* SEQUENCE OF Module */


typedef ALIST ImportModuleList; /* SEQUENCE OF ImportModule */


typedef ALIST ImportElmtList; /* SEQUENCE OF ImportElmt */


typedef ALIST TypeDefList; /* SEQUENCE OF TypeDef */


typedef ALIST TagList; /* SEQUENCE OF Tag */


typedef ALIST AttributeList; /* SEQUENCE OF MyString */


typedef ALIST NamedTypeList; /* SEQUENCE OF NamedType */


typedef ALIST ValueList; /* SEQUENCE OF Value */


typedef ALIST TypeOrValueList; /* SEQUENCE OF TypeOrValue */


typedef ALIST OidList; /* SEQUENCE OF OBJECT IDENTIFIER */


typedef ALIST AsnPortList; /* SEQUENCE OF AsnPort */


typedef AINT AsnRefineMacroType; /* INTEGER */


typedef ALIST SubtypeList; /* SEQUENCE OF Subtype */


typedef ALIST ConstraintList; /* SEQUENCE OF ConstrAINT */


typedef ALIST ValueDefList; /* SEQUENCE OF ValueDef */


typedef enum
    {
        MIN_INT = 0,
        MAX_INT = 1
    } SpecialIntegerValue; /* ENUMERATED { MIN_INT(0), MAX_INT(1) }  */


typedef enum
    {
        MINUS_INFINITY_REAL = 0,
        PLUS_INFINITY_REAL = 1
    } SpecialRealValue; /* ENUMERATED { MINUS_INFINITY_REAL(0), PLUS_INFINITY_REAL(1) }  */


typedef ALIST NamedValueList; /* SEQUENCE OF NamedValue */


typedef enum
    {
        C_CHOICE = 0,
        C_LIST = 1,
        C_ANY = 2,
        C_ANYDEFINEDBY = 3,
        C_LIB = 4,
        C_STRUCT = 5,
        C_TYPEREF = 6,
        C_NO_TYPE = 7,
        C_TYPEDEF = 8
    } CTypeId; 


typedef ALIST CNamedElmts; /* SEQUENCE OF CNamedElmt */


typedef char* MyString; /* OCTET STRING */


typedef ValueDefList NamedNumberList; /* ValueDefList */


typedef MyString MacroDef; /* MyString */


typedef struct ImportElmtChoice /* CHOICE */
{
    enum ImportElmtChoiceChoiceId
    {
        IMPORTELMTCHOICE_TYPE,
        IMPORTELMTCHOICE_VALUE
    } choiceId;
    union ImportElmtChoiceChoiceUnion
    {
    struct TypeDef* type; /* [0] TypeDef */
    struct ValueDef* value; /* [1] ValueDef */
    } a;
} ImportElmtChoice;




typedef struct Modules /* [APPLICATION 0] IMPLICIT SEQUENCE */
{
    AINT creationTime; /* INTEGER */
    ModuleList* modules; /* ModuleList */
} Modules;


typedef struct Module /* SEQUENCE */
{
    enum
    {
        MOD_OK = 0,
        MOD_NOT_LINKED = 1,
        MOD_ERROR = 2
    } status; /* ENUMERATED { MOD_OK(0), MOD_NOT_LINKED(1), MOD_ERROR(2) }  */
    struct ModuleId* modId; /* ModuleId */
    enum
    {
        EXPLICIT_TAGS = 0,
        IMPLICIT_TAGS = 1
    } tagDefault; /* ENUMERATED { EXPLICIT_TAGS(0), IMPLICIT_TAGS(1) }  */
    enum
    {
        EXPORTS_ALL = 0,
        EXPORTS_NOTHING = 1,
        EXPORTS_SOME = 2
    } exportStatus; /* ENUMERATED { EXPORTS_ALL(0), EXPORTS_NOTHING(1), EXPORTS_SOME(2) }  */
    ImportModuleList* imports; /* ImportModuleList */
    TypeDefList* typeDefs; /* TypeDefList */
    ValueDefList* valueDefs; /* ValueDefList */
    ABOOL hasAnys;
    MyString asn1SrcFileName; /* MyString */
    MyString cHdrFileName; /* MyString */
    MyString cSrcFileName; /* MyString */
    MyString cppHdrFileName; /* MyString */
    MyString cppSrcFileName; /* MyString */
} Module;


typedef struct ModuleId /* SEQUENCE */
{
    MyString name; /* MyString */
    OID* oid; /* OBJECT IDENTIFIER OPTIONAL */
} ModuleId;


typedef struct ImportModule /* SEQUENCE */
{
    struct ModuleId* modId; /* ModuleId */
    ImportElmtList* importElmts; /* ImportElmtList */
    struct Module* moduleRef; /* Module */
} ImportModule;


typedef struct ImportElmt /* SEQUENCE */
{
    struct ImportElmtChoice* resolvedRef; /* ImportElmtChoice OPTIONAL */
    MyString name; /* MyString */
    ABOOL privateScope;  /* if of form MODNAME.TYPE */
} ImportElmt;


typedef struct OidOrInt
{
    enum { OIDORINT_OID, OIDORINT_INTID } choiceId;
    union OidOrIntChoiceUnion
    {
        AOID* oid;
        AINT  intId;
    } a;
} OidOrInt;

typedef struct AnyRef
{
    MyString anyIdName;
    OidOrInt* id;
} AnyRef;

typedef ALIST AnyRefList;

typedef struct TypeDef /* SEQUENCE */
{
    ABOOL exported; /* BOOLEAN */
    ABOOL recursive; /* BOOLEAN */
    AINT  localRefCount; /* INTEGER */
    AINT  importRefCount; /* INTEGER */
    AINT  tmpRefCount; /* INTEGER */
    ABOOL visited; /* BOOLEAN */
    MyString definedName; /* MyString */
    struct Type* type; /* Type */
    struct CTDI* cTypeDefInfo; /* CTDI */
    struct CppTDI* cppTypeDefInfo; /* CppTDI */
    AttributeList* attrList; /* AttributeList */
    TypeDefList* refList; /* AttributeList */
    AnyRefList* anyRefs;
} TypeDef;


typedef struct Tag /* SEQUENCE */
{
    AINT class; /* INTEGER */
    AINT form; /* INTEGER */
    AINT code; /* INTEGER */
    ABOOL explicit; /* BOOLEAN */
    struct Value* valueRef; /* Value */
} Tag;


typedef struct Type /* SEQUENCE */
{
    ABOOL optional; /* BOOLEAN */
    ABOOL implicit; /* BOOLEAN */
    TagList* tags; /* TagList */
    struct NamedValue* defaultVal; /* [0] IMPLICIT NamedValue OPTIONAL */
    struct Subtype* subtypes; /* [1] Subtype OPTIONAL */
    struct BasicType* basicType; /* [2] BasicType */
    AINT lineNo; /* INTEGER */
    struct CTRI* cTypeRefInfo; /* CTRI */
    struct CppTRI* cppTypeRefInfo; /* CppTRI */
    AttributeList* attrList; /* AttributeList */
} Type;


typedef struct BasicType /* CHOICE */
{
    enum BasicTypeChoiceId
    {
        BASICTYPE_UNKNOWN,
        BASICTYPE_BOOLEAN,
        BASICTYPE_INTEGER,
        BASICTYPE_BITSTRING,
        BASICTYPE_OCTETSTRING,
        BASICTYPE_NULL,
        BASICTYPE_OID,
        BASICTYPE_REAL,
        BASICTYPE_ENUMERATED,
        BASICTYPE_SEQUENCE,
        BASICTYPE_SEQUENCEOF,
        BASICTYPE_SET,
        BASICTYPE_SETOF,
        BASICTYPE_CHOICE,
        BASICTYPE_SELECTION,
        BASICTYPE_COMPONENTSOF,
        BASICTYPE_ANY,
        BASICTYPE_ANYDEFINEDBY,
        BASICTYPE_LOCALTYPEREF,
        BASICTYPE_IMPORTTYPEREF,
        BASICTYPE_MACROTYPE,
        BASICTYPE_MACRODEF
    } choiceId;
    union BasicTypeChoiceUnion
    {
    ANULL unknown; /* [0] IMPLICIT NULL */
    ANULL boolean; /* [1] IMPLICIT NULL */
    NamedNumberList* integer; /* [2] IMPLICIT NamedNumberList */
    NamedNumberList* bitString; /* [3] IMPLICIT NamedNumberList */
    ANULL octetString; /* [4] IMPLICIT NULL */
    ANULL null; /* [5] IMPLICIT NULL */
    ANULL oid; /* [6] IMPLICIT NULL */
    ANULL real; /* [7] IMPLICIT NULL */
    NamedNumberList* enumerated; /* [8] IMPLICIT NamedNumberList */
    NamedTypeList* sequence; /* [9] IMPLICIT NamedTypeList */
    struct Type* sequenceOf; /* [10] IMPLICIT Type */
    NamedTypeList* set; /* [11] IMPLICIT NamedTypeList */
    struct Type* setOf; /* [12] IMPLICIT Type */
    NamedTypeList* choice; /* [13] IMPLICIT NamedTypeList */
    struct SelectionType* selection; /* [14] IMPLICIT SelectionType */
    struct Type* componentsOf; /* [15] IMPLICIT Type */
    ANULL any; /* [16] IMPLICIT NULL */
    struct AnyDefinedByType* anyDefinedBy; /* [17] IMPLICIT AnyDefinedByType */
    struct TypeRef* localTypeRef; /* [19] IMPLICIT TypeRef */
    struct TypeRef* importTypeRef; /* [20] IMPLICIT TypeRef */
    struct MacroType* macroType; /* [21] MacroType */
    MacroDef macroDef; /* [22] IMPLICIT MacroDef */
    } a;
} BasicType;




typedef struct MacroType /* CHOICE */
{
    enum MacroTypeChoiceId
    {
        MACROTYPE_ROSOPERATION,
        MACROTYPE_ROSERROR,
        MACROTYPE_ROSBIND,
        MACROTYPE_ROSUNBIND,
        MACROTYPE_ROSASE,
        MACROTYPE_ROSAC,
        MACROTYPE_MTSASEXTENSION,
        MACROTYPE_MTSASEXTENSIONS,
        MACROTYPE_MTSASEXTENSIONATTRIBUTE,
        MACROTYPE_MTSASTOKEN,
        MACROTYPE_MTSASTOKENDATA,
        MACROTYPE_MTSASSECURITYCATEGORY,
        MACROTYPE_ASNOBJECT,
        MACROTYPE_ASNPORT,
        MACROTYPE_ASNREFINE,
        MACROTYPE_ASNABSTRACTBIND,
        MACROTYPE_ASNABSTRACTUNBIND,
        MACROTYPE_ASNABSTRACTOPERATION,
        MACROTYPE_ASNABSTRACTERROR,
        MACROTYPE_AFALGORITHM,
        MACROTYPE_AFENCRYPTED,
        MACROTYPE_AFPROTECTED,
        MACROTYPE_AFSIGNATURE,
        MACROTYPE_AFSIGNED,
        MACROTYPE_SNMPOBJECTTYPE
    } choiceId;
    union MacroTypeChoiceUnion
    {
    struct RosOperationMacroType* rosOperation; /* [0] IMPLICIT RosOperationMacroType */
    struct RosErrorMacroType* rosError; /* [1] IMPLICIT RosErrorMacroType */
    struct RosBindMacroType* rosBind; /* [2] IMPLICIT RosBindMacroType */
    struct RosBindMacroType* rosUnbind; /* [3] IMPLICIT RosBindMacroType */
    struct RosAseMacroType* rosAse; /* [4] IMPLICIT RosAseMacroType */
    struct RosAcMacroType* rosAc; /* [5] IMPLICIT RosAcMacroType */
    struct MtsasExtensionMacroType* mtsasExtension; /* [6] IMPLICIT MtsasExtensionMacroType */
    struct MtsasExtensionsMacroType* mtsasExtensions; /* [7] IMPLICIT MtsasExtensionsMacroType */
    struct MtsasExtensionAttributeMacroType* mtsasExtensionAttribute; /* [8] IMPLICIT MtsasExtensionAttributeMacroType */
    struct MtsasTokenMacroType* mtsasToken; /* [9] IMPLICIT MtsasTokenMacroType */
    struct MtsasTokenDataMacroType* mtsasTokenData; /* [10] IMPLICIT MtsasTokenDataMacroType */
    struct MtsasSecurityCategoryMacroType* mtsasSecurityCategory; /* [11] IMPLICIT MtsasSecurityCategoryMacroType */
    struct AsnObjectMacroType* asnObject; /* [12] IMPLICIT AsnObjectMacroType */
    struct AsnPortMacroType* asnPort; /* [13] IMPLICIT AsnPortMacroType */
    AsnRefineMacroType asnRefine; /* [14] IMPLICIT AsnRefineMacroType */
    struct AsnAbstractBindMacroType* asnAbstractBind; /* [15] IMPLICIT AsnAbstractBindMacroType */
    struct AsnAbstractBindMacroType* asnAbstractUnbind; /* [16] IMPLICIT AsnAbstractBindMacroType */
    struct RosOperationMacroType* asnAbstractOperation; /* [17] IMPLICIT RosOperationMacroType */
    struct RosErrorMacroType* asnAbstractError; /* [18] IMPLICIT RosErrorMacroType */
    struct Type* afAlgorithm; /* [19] IMPLICIT Type */
    struct Type* afEncrypted; /* [20] IMPLICIT Type */
    struct Type* afProtected; /* [21] IMPLICIT Type */
    struct Type* afSignature; /* [22] IMPLICIT Type */
    struct Type* afSigned; /* [23] IMPLICIT Type */
    struct SnmpObjectTypeMacroType* snmpObjectType; /* [24] IMPLICIT SnmpObjectTypeMacroType */
    } a;
} MacroType;




typedef struct AnyDefinedByType /* SEQUENCE */
{
    MyString fieldName; /* MyString */
    struct NamedType* link; /* NamedType OPTIONAL */
} AnyDefinedByType;


typedef struct SelectionType /* SEQUENCE */
{
    MyString fieldName; /* MyString */
    struct Type* typeRef; /* Type */
    struct NamedType* link; /* NamedType OPTIONAL */
} SelectionType;


typedef struct NamedType /* SEQUENCE */
{
    MyString fieldName; /* MyString */
    struct Type* type; /* Type */
} NamedType;


typedef struct TypeRef /* SEQUENCE */
{
    MyString typeName; /* MyString */
    MyString moduleName; /* MyString */
    struct Module* module; /* Module */
    struct TypeDef* link; /* TypeDef */
} TypeRef;


typedef struct RosOperationMacroType /* SEQUENCE */
{
    struct NamedType* arguments; /* NamedType */
    struct NamedType* result; /* NamedType */
    TypeOrValueList* errors; /* [0] IMPLICIT TypeOrValueList OPTIONAL */
    TypeOrValueList* linkedOps; /* [1] IMPLICIT TypeOrValueList OPTIONAL */
} RosOperationMacroType;


typedef struct TypeOrValue /* CHOICE */
{
    enum TypeOrValueChoiceId
    {
        TYPEORVALUE_TYPE,
        TYPEORVALUE_VALUE
    } choiceId;
    union TypeOrValueChoiceUnion
    {
    struct Type* type; /* [0] IMPLICIT Type */
    struct Value* value; /* [1] IMPLICIT Value */
    } a;
} TypeOrValue;




typedef struct RosErrorMacroType /* SEQUENCE */
{
    struct NamedType* parameter; /* NamedType */
} RosErrorMacroType;


typedef struct RosBindMacroType /* SEQUENCE */
{
    struct NamedType* argument; /* NamedType */
    struct NamedType* result; /* NamedType */
    struct NamedType* error; /* NamedType */
} RosBindMacroType;


typedef struct RosAseMacroType /* SEQUENCE */
{
    ValueList* operations; /* ValueList */
    ValueList* consumerInvokes; /* ValueList */
    ValueList* supplierInvokes; /* ValueList */
} RosAseMacroType;


typedef struct RosAcMacroType /* SEQUENCE */
{
    ValueList* nonRoElements; /* ValueList */
    struct Type* bindMacroType; /* Type */
    struct Type* unbindMacroType; /* Type */
    struct Value* remoteOperations; /* Value */
    ValueList* operationsOf; /* ValueList */
    ValueList* initiatorConsumerOf; /* ValueList */
    ValueList* responderConsumerOf; /* ValueList */
    OidList* abstractSyntaxes; /* OidList */
} RosAcMacroType;


typedef struct MtsasExtensionMacroType /* SEQUENCE */
{
    struct NamedType* elmtType; /* [0] IMPLICIT NamedType OPTIONAL */
    struct Value* defaultValue; /* [1] IMPLICIT Value OPTIONAL */
    ABOOL* criticalForSubmission; /* [2] IMPLICIT BOOLEAN OPTIONAL */
    ABOOL* criticalForTransfer; /* [3] IMPLICIT BOOLEAN OPTIONAL */
    ABOOL* criticalForDelivery; /* [4] IMPLICIT BOOLEAN OPTIONAL */
} MtsasExtensionMacroType;


typedef struct MtsasExtensionsMacroType /* SEQUENCE */
{
    ValueList* extensions; /* ValueList */
} MtsasExtensionsMacroType;


typedef struct MtsasExtensionAttributeMacroType /* SEQUENCE */
{
    struct Type* type; /* Type OPTIONAL */
} MtsasExtensionAttributeMacroType;


typedef struct MtsasTokenMacroType /* SEQUENCE */
{
    struct Type* type; /* Type OPTIONAL */
} MtsasTokenMacroType;


typedef struct MtsasTokenDataMacroType /* SEQUENCE */
{
    struct Type* type; /* Type OPTIONAL */
} MtsasTokenDataMacroType;


typedef struct MtsasSecurityCategoryMacroType /* SEQUENCE */
{
    struct Type* type; /* Type OPTIONAL */
} MtsasSecurityCategoryMacroType;


typedef struct AsnObjectMacroType /* SEQUENCE */
{
    AsnPortList* ports; /* AsnPortList OPTIONAL */
} AsnObjectMacroType;


typedef struct AsnPort /* SEQUENCE */
{
    struct Value* portValue; /* Value */
    enum
    {
        CONSUMER_PORT = 0,
        SUPPLIER_PORT = 1,
        SYMMETRIC_PORT = 2
    } portType; /* ENUMERATED { CONSUMER_PORT(0), SUPPLIER_PORT(1), SYMMETRIC_PORT(2) }  */
} AsnPort;


typedef struct AsnPortMacroType /* SEQUENCE */
{
    TypeOrValueList* abstractOps; /* [0] IMPLICIT TypeOrValueList OPTIONAL */
    TypeOrValueList* consumerInvokes; /* [1] IMPLICIT TypeOrValueList OPTIONAL */
    TypeOrValueList* supplierInvokes; /* [2] IMPLICIT TypeOrValueList OPTIONAL */
} AsnPortMacroType;


typedef struct AsnAbstractBindMacroType /* SEQUENCE */
{
    AsnPortList* ports; /* [0] IMPLICIT AsnPortList OPTIONAL */
    struct Type* type; /* [1] IMPLICIT Type OPTIONAL */
} AsnAbstractBindMacroType;


typedef struct SnmpObjectTypeMacroType /* SEQUENCE */
{
    struct Type* syntax; /* Type */
    enum
    {
        SNMP_READ_ONLY = 0,
        SNMP_READ_WRITE = 1,
        SNMP_WRITE_ONLY = 2,
        SNMP_NOT_ACCESSIBLE = 3
    } access; /* ENUMERATED { SNMP_READ_ONLY(0), SNMP_READ_WRITE(1), SNMP_WRITE_ONLY(2), SNMP_NOT_ACCESSIBLE(3) }  */
    enum
    {
        SNMP_MANDATORY = 0,
        SNMP_OPTIONAL = 1,
        SNMP_OBSOLETE = 2,
        SNMP_DEPRECATED = 3
    } status; /* ENUMERATED { SNMP_MANDATORY(0), SNMP_OPTIONAL(1), SNMP_OBSOLETE(2), SNMP_DEPRECATED(3) }  */
    struct Value* description; /* [0] IMPLICIT Value OPTIONAL */
    struct Value* reference; /* [1] IMPLICIT Value OPTIONAL */
    TypeOrValueList* index; /* [2] IMPLICIT TypeOrValueList OPTIONAL */
    struct Value* defVal; /* [3] IMPLICIT Value OPTIONAL */
} SnmpObjectTypeMacroType;


typedef struct Subtype /* CHOICE */
{
    enum SubtypeChoiceId
    {
        SUBTYPE_SINGLE,
        SUBTYPE_AND,
        SUBTYPE_OR,
        SUBTYPE_NOT
    } choiceId;
    union SubtypeChoiceUnion
    {
    struct SubtypeValue* single; /* [0] SubtypeValue */
    SubtypeList* and; /* [1] IMPLICIT SubtypeList */
    SubtypeList* or; /* [2] IMPLICIT SubtypeList */
    struct Subtype* not; /* [3] Subtype */
    } a;
} Subtype;




typedef struct SubtypeValue /* CHOICE */
{
    enum SubtypeValueChoiceId
    {
        SUBTYPEVALUE_SINGLEVALUE,
        SUBTYPEVALUE_CONTAINED,
        SUBTYPEVALUE_VALUERANGE,
        SUBTYPEVALUE_PERMITTEDALPHABET,
        SUBTYPEVALUE_SIZECONSTRAINT,
        SUBTYPEVALUE_INNERSUBTYPE
    } choiceId;
    union SubtypeValueChoiceUnion
    {
    struct Value* singleValue; /* [0] IMPLICIT Value */
    struct Type* contained; /* [1] IMPLICIT Type */
    struct ValueRangeSubtype* valueRange; /* [2] IMPLICIT ValueRangeSubtype */
    struct Subtype* permittedAlphabet; /* [3] Subtype */
    struct Subtype* sizeConstraint; /* [4] Subtype */
    struct InnerSubtype* innerSubtype; /* [5] IMPLICIT InnerSubtype */
    } a;
} SubtypeValue;




typedef struct ValueRangeSubtype /* SEQUENCE */
{
    ABOOL lowerEndInclusive; /* BOOLEAN */
    ABOOL upperEndInclusive; /* BOOLEAN */
    struct Value* lowerEndValue; /* Value */
    struct Value* upperEndValue; /* Value */
} ValueRangeSubtype;


typedef struct InnerSubtype /* SEQUENCE */
{
    enum
    {
        FULL_CT = 0,
        PARTIAL_CT = 1,
        SINGLE_CT = 2
    } constraintType; /* ENUMERATED { FULL_CT(0), PARTIAL_CT(1), SINGLE_CT(2) }  */
    ConstraintList* constraints; /* ConstrAINTList */
} InnerSubtype;


typedef struct Constraint /* SEQUENCE */
{
    MyString fieldRef; /* MyString */
    enum
    {
        PRESENT_CT = 0,
        ABSENT_CT = 1,
        EMPTY_CT = 2,
        OPTIONAL_CT = 3
    } presenceConstraint; /* ENUMERATED { PRESENT_CT(0), ABSENT_CT(1), EMPTY_CT(2), OPTIONAL_CT(3) }  */
    struct Subtype* valueConstraints; /* Subtype */
} Constraint;


typedef struct ValueDef /* SEQUENCE */
{
    ABOOL exported; /* BOOLEAN */
    MyString definedName; /* MyString */
    struct Value* value; /* Value */
} ValueDef;


typedef struct Value /* SEQUENCE */
{
    struct Type* type; /* Type OPTIONAL */
    AINT valueType; /* INTEGER */
    struct BasicValue* basicValue; /* BasicValue */
    AINT lineNo; /* INTEGER */
} Value;


typedef struct BasicValue /* CHOICE */
{
    enum BasicValueChoiceId
    {
        BASICVALUE_UNKNOWN,
        BASICVALUE_EMPTY,
        BASICVALUE_INTEGER,
        BASICVALUE_SPECIALINTEGER,
        BASICVALUE_LONGINTEGER,
        BASICVALUE_BOOLEAN,
        BASICVALUE_REAL,
        BASICVALUE_SPECIALREAL,
        BASICVALUE_ASCIITEXT,
        BASICVALUE_ASCIIHEX,
        BASICVALUE_ASCIIBITSTRING,
        BASICVALUE_OID,
        BASICVALUE_LINKEDOID,
        BASICVALUE_BERVALUE,
        BASICVALUE_PERVALUE,
        BASICVALUE_NAMEDVALUE,
        BASICVALUE_NULL,
        BASICVALUE_LOCALVALUEREF,
        BASICVALUE_IMPORTVALUEREF,
        BASICVALUE_VALUENOTATION
    } choiceId;
    union BasicValueChoiceUnion
    {
    ANULL unknown; /* [0] IMPLICIT NULL */
    ANULL empty; /* [1] IMPLICIT NULL */
    AINT integer; /* [2] IMPLICIT INTEGER */
    SpecialIntegerValue specialInteger; /* [3] IMPLICIT SpecialIntegerValue */
    AINT longInteger; /* [4] IMPLICIT INTEGER */
    ABOOL boolean; /* [5] IMPLICIT BOOLEAN */
    AREAL real; /* [6] IMPLICIT REAL */
    SpecialRealValue specialReal; /* [7] IMPLICIT SpecialRealValue */
    AOCTS* asciiText; /* [8] IMPLICIT OCTET STRING */
    AOCTS* asciiHex; /* [9] IMPLICIT OCTET STRING */
    AOCTS* asciiBitString; /* [10] IMPLICIT OCTET STRING */
    AOID* oid; /* [11] IMPLICIT OBJECT IDENTIFIER */
    OID* linkedOid; /* [12] IMPLICIT OBJECT IDENTIFIER */
    AOCTS* berValue; /* [13] IMPLICIT OCTET STRING */
    AOCTS* perValue; /* [14] IMPLICIT OCTET STRING */
    struct NamedValue* namedValue; /* [15] IMPLICIT NamedValue */
    ANULL null; /* [16] IMPLICIT NULL */
    struct ValueRef* localValueRef; /* [17] IMPLICIT ValueRef */
    struct ValueRef* importValueRef; /* [18] IMPLICIT ValueRef */
    AOCTS* valueNotation; /* [19] IMPLICIT OCTET STRING */
    } a;
} BasicValue;




typedef struct ValueRef /* SEQUENCE */
{
    MyString valueName; /* MyString */
    MyString moduleName; /* MyString */
    struct ValueDef* link; /* ValueDef */
    struct Module* module; /* Module */
} ValueRef;


typedef struct NamedValue /* SEQUENCE */
{
    MyString fieldName; /* MyString */
    struct Value* value; /* Value */
} NamedValue;


typedef struct CTDI /* SEQUENCE */
{
    enum BasicTypeChoiceId asn1TypeId; /* INTEGER */
    CTypeId cTypeId; /* CTypeId */
    MyString cTypeName; /* MyString */
    ABOOL isPdu; /* BOOLEAN */
    ABOOL isEncDec; /* BOOLEAN */
    ABOOL isPtrForTypeDef; /* BOOLEAN */
    ABOOL isPtrForTypeRef; /* BOOLEAN */
    ABOOL isPtrInChoice; /* BOOLEAN */
    ABOOL isPtrForOpt; /* BOOLEAN */
    MyString optTestRoutineName; /* MyString */
    MyString defaultFieldName; /* MyString */
    MyString printRoutineName; /* MyString */
    MyString encodeRoutineName; /* MyString */
    MyString decodeRoutineName; /* MyString */
    MyString freeRoutineName; /* MyString */
    ABOOL genPrintRoutine; /* BOOLEAN */
    ABOOL genEncodeRoutine; /* BOOLEAN */
    ABOOL genDecodeRoutine; /* BOOLEAN */
    ABOOL genFreeRoutine; /* BOOLEAN */
    ABOOL genTypeDef;
} CTDI;


typedef struct CTRI /* SEQUENCE */
{
    CTypeId cTypeId; /* CTypeId */
    MyString cFieldName; /* MyString */
    MyString cTypeName; /* MyString */
    ABOOL isPtr; /* BOOLEAN */
/*    ABOOL isEndCType;  BOOLEAN */
    CNamedElmts* cNamedElmts; /* CNamedElmts OPTIONAL */
    AINT choiceIdValue; /* INTEGER */
    MyString choiceIdSymbol; /* MyString */
    MyString choiceIdEnumName; /* MyString */
    MyString choiceIdEnumFieldName; /* MyString */
    MyString optTestRoutineName; /* MyString */
    MyString printRoutineName; /* MyString */
    MyString encodeRoutineName; /* MyString */
    MyString decodeRoutineName; /* MyString */
    MyString freeRoutineName; /* MyString */
    ABOOL isEncDec; /* BOOLEAN */
} CTRI;


typedef struct CNamedElmt /* SEQUENCE */
{
    MyString name; /* MyString */
    AINT value; /* INTEGER */
} CNamedElmt;


typedef struct CppTDI /* SEQUENCE */
{
    enum BasicTypeChoiceId asn1TypeId;
    MyString className; /* MyString */
    ABOOL isPdu; /* BOOLEAN */
    ABOOL isEnc; /* BOOLEAN */
    ABOOL isPtrForTypeDef; /* BOOLEAN */
    ABOOL isPtrForOpt; /* BOOLEAN */
    ABOOL isPtrInChoice; /* BOOLEAN */
    ABOOL isPtrInSetAndSeq; /* BOOLEAN */
    ABOOL isPtrInList; /* BOOLEAN */
    MyString optTestRoutineName; /* MyString */
    MyString defaultFieldName; /* MyString */
} CppTDI;


typedef struct CppTRI /* SEQUENCE */
{
    ABOOL isEnc; /* BOOLEAN */
    MyString className; /* MyString */
    MyString fieldName; /* MyString */
    ABOOL isPtr; /* BOOLEAN */
    CNamedElmts* namedElmts; /* CNamedElmts */
    MyString choiceIdSymbol; /* MyString */
    AINT choiceIdValue;
    MyString optTestRoutineName; /* MyString */
} CppTRI;



#endif /* _asn1module_h_ */



