/*
 * asn_enum.c - routines for the ASN.1 ENUMERATED type
 *
 * MS 92
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 */

#include "asn_config.h"
#include "asn_len.h"
#include "asn_tag.h"
#include "asn_int.h"
#include "asn_enum.h"

/*
 * encodes universal TAG LENGTH and Contents of and ASN.1 ENUMERATED
 */
AsnLen
BEncAsnEnum PARAMS((b, data),
BUF_TYPE     b _AND_
AsnEnum* data)
{
    AsnLen len;

    len =  BEncAsnEnumContent(b, data);
    len += BEncDefLen(b, len);
    len += BEncTag1(b, UNIV, PRIM, ENUM_TAG_CODE);
    return(len);
}  /* BEncAsnEnum */


/* 
 * decodes universal TAG LENGTH and Contents of and ASN.1 ENUMERATED
 */
void
BDecAsnEnum PARAMS((b, result, bytesDecoded, env),
BUF_TYPE   b _AND_
AsnEnum*    result _AND_
AsnLen* bytesDecoded _AND_
jmp_buf env)
{
    AsnTag tag;
    AsnLen elmtLen;

    if ( (tag =BDecTag(b, bytesDecoded, env)) !=
        MAKE_TAG_ID(UNIV, PRIM, ENUM_TAG_CODE))
    {
         Asn1Error("BDecAsnInt: ERROR wrong tag on ENUMERATED.\n");
         longjmp(env, -40);
    }

    elmtLen = BDecLen (b, bytesDecoded, env);
    BDecAsnEnumContent( b, tag, elmtLen, result, bytesDecoded, env);

}  /* BDecAsnEnum */


