/*
 * asn_real.h
 *
 * MS 92
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */


#ifndef _asn_real_h_
#define _asn_real_h_

typedef double AsnReal;

extern AsnReal PLUS_INFINITY;
extern AsnReal MINUS_INFINITY;


void InitAsnInfinity();

AsnLen BEncAsnReal PROTO((BUF_TYPE b, AsnReal* data));

void BDecAsnReal PROTO((BUF_TYPE b, AsnReal* result, AsnLen* bytesDecoded,
                       ENV_TYPE env));

AsnLen BEncAsnRealContent PROTO((BUF_TYPE b, AsnReal* data));

void BDecAsnRealContent PROTO((BUF_TYPE b,
                               AsnTag tag,
                               AsnLen len,
                               AsnReal* result,
                               AsnLen* bytesDecoded,
                               ENV_TYPE env));

/* do nothing */ 
#define FreeAsnReal(v)

void PrintAsnReal PROTO((FILE* f, AsnReal* b, unsigned short int indent));

#endif
