/*
 * genber.c - builds a PersonnelRecord value and writes BER form
 *            of the value to a file called "pr.ber"
 *
 *
 *  MS 92
 */


#include <stdio.h>
#include <sys/stdtypes.h>
#include <stddef.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/stat.h>
#include "asn_incl.h"
#include "p_rec.h"


main (int argc, char* argv[])
{
    FILE* outputFile;
    SBuf outputBuf;
    unsigned long int encodedLen;
    int dataSize = 1024;
    int i;
    char data[1024];
    PersonnelRecord pr;
    ChildInformation** childHndl;

    /* used to alloc part of value (Asn1Alloc & AsnListAppend) */
    InitNibbleMem(512,512); 

    pr.name = Asn1Alloc(sizeof(Name));
    pr.name->givenName.octs = "John";
    pr.name->givenName.octetLen = strlen(pr.name->givenName.octs);
    pr.name->initial.octs = "E";
    pr.name->initial.octetLen = strlen(pr.name->initial.octs);
    pr.name->familyName.octs = "Smith";
    pr.name->familyName.octetLen = strlen(pr.name->familyName.octs);

    pr.title.octs = "The Big Cheese";
    pr.title.octetLen = strlen(pr.title.octs);

    pr.employeeNumber = 99999;

    pr.dateOfHire.octs = "19820104";
    pr.dateOfHire.octetLen = strlen(pr.dateOfHire.octs);

    pr.nameOfSpouse = (Name*) Asn1Alloc(sizeof(Name));
    pr.nameOfSpouse->givenName.octs = "Mary";
    pr.nameOfSpouse->givenName.octetLen = 
        strlen(pr.nameOfSpouse->givenName.octs);
    pr.nameOfSpouse->initial.octs = "L";
    pr.nameOfSpouse->initial.octetLen = strlen(pr.nameOfSpouse->initial.octs);
    pr.nameOfSpouse->familyName.octs = "Smith";
    pr.nameOfSpouse->familyName.octetLen =
        strlen(pr.nameOfSpouse->familyName.octs);

    pr.children = AsnListNew(sizeof(void*));

    childHndl = AsnListAppend(pr.children);
    *childHndl = Asn1Alloc(sizeof(ChildInformation));

    (*childHndl)->dateOfBirth.octs = "19570310";
    (*childHndl)->dateOfBirth.octetLen  = strlen((*childHndl)->dateOfBirth.octs);
    (*childHndl)->name = (Name*) Asn1Alloc(sizeof(Name));

    (*childHndl)->name->givenName.octs = "James";
    (*childHndl)->name->givenName.octetLen = 
        strlen((*childHndl)->name->givenName.octs);
    (*childHndl)->name->initial.octs = "R";
    (*childHndl)->name->initial.octetLen = 
        strlen((*childHndl)->name->initial.octs);
    (*childHndl)->name->familyName.octs = "Smith";
    (*childHndl)->name->familyName.octetLen = 
        strlen((*childHndl)->name->familyName.octs);

    childHndl = AsnListAppend(pr.children);
    *childHndl = Asn1Alloc(sizeof(ChildInformation));

    (*childHndl)->dateOfBirth.octs = "19610621";
    (*childHndl)->dateOfBirth.octetLen  = strlen((*childHndl)->dateOfBirth.octs);

    (*childHndl)->name = (Name*) Asn1Alloc(sizeof(Name));

    (*childHndl)->name->givenName.octs = "Lisa";
    (*childHndl)->name->givenName.octetLen = 
        strlen((*childHndl)->name->givenName.octs);
    (*childHndl)->name->initial.octs = "M";
    (*childHndl)->name->initial.octetLen =
        strlen((*childHndl)->name->initial.octs);
    (*childHndl)->name->familyName.octs = "Smith";
    (*childHndl)->name->familyName.octetLen = 
        strlen((*childHndl)->name->familyName.octs);

    SBufInit(&outputBuf,data, dataSize);
    SBufResetInWriteRvsMode(&outputBuf);

    encodedLen = BEncPersonnelRecord(&outputBuf, &pr);

    /*
     * after encoding a value ALWAYS check for write error
     * in the buffer.  The encode routine do not use longjmp
     * when they enter an error state
     */
    if ((encodedLen <= 0) || (SBufWriteError(&outputBuf)))
    {
        fprintf(stderr,"failed encoding PersonnelRecord value\n");
        exit(1);
    }

    outputFile = fopen("pr.ber", "w");
    if (!outputFile)
    {
        perror("fopen:");
        exit(1);
    }

    SBufResetInReadMode(&outputBuf);
    for ( ; encodedLen > 0; encodedLen--)
        fputc(SBufGetByte(&outputBuf), outputFile); 


    printf("Wrote the following BER PersonnelRecord value to pr.ber.\n");
    printf("Test it with \"def\" and \"indef\"\n");

    PrintPersonnelRecord(stdout, &pr, 0);
    printf("\n");

    return(0);
}
