//
// asn_useful.C - class member functions for ASN.1 module ASN-USEFUL
//
//   This file was generated by snacc on Mon Dec 14 20:25:39 1992
//   UBC snacc written by Mike Sample
//   NOTE: this is a machine generated file - editing not recommended
//


#include "asn_incl.h"


AsnLen
EXTERNALChoice::BEncContent(BUF_TYPE b)
{
    AsnLen l;
    switch(choiceId)
    {
       case(single_ASN1_typeCid):
    BEncEocIfNec(b);
    l = single_ASN1_type->BEncContent(b);
    l += BEncDefLen( b, l);
    l += BEncTag1(b, UNIV, PRIM, OCTETSTRING_TAG_CODE);
    l += BEncConsLen( b, l);
    l += BEncTag1(b, CNTX, CONS, 0);
    break;

       case(octet_alignedCid):
    l = octet_aligned->BEncContent(b);
    l += BEncDefLen( b, l);
    l += BEncTag1(b, CNTX, PRIM, 1);
    break;

       case(arbitraryCid):
    l = arbitrary->BEncContent(b);
    l += BEncDefLen( b, l);
    l += BEncTag1(b, CNTX, PRIM, 2);
    break;

    } /* end switch */
    return(l);
} /* EXTERNALChoice::BEncContent */


void
EXTERNALChoice::BDecContent(BUF_TYPE b, AsnTag tag, AsnLen elmtLen0, AsnLen& bytesDecoded, ENV_TYPE env)
{
    AsnLen elmtLen1;
    switch(tag)
    {
      case(MAKE_TAG_ID( CNTX, CONS, 0)):
        tag = BDecTag(b, bytesDecoded, env);
        if ((tag != MAKE_TAG_ID( UNIV, PRIM, OCTETSTRING_TAG_CODE)) &&
            (tag != MAKE_TAG_ID( UNIV, CONS, OCTETSTRING_TAG_CODE)))
        {
             Asn1Error("Unexpected Tag\n");
             longjmp(env, -63);
        }

        elmtLen1 = BDecLen (b, bytesDecoded, env);
        choiceId = single_ASN1_typeCid;
        single_ASN1_type = new AsnOcts;
        single_ASN1_type->BDecContent(b, tag, elmtLen1, bytesDecoded, env);
        if (elmtLen0 == INDEFINITE_LEN)
            BDecEoc(b, bytesDecoded, env);
        break;

      case(MAKE_TAG_ID( CNTX, PRIM, 1)):
      case(MAKE_TAG_ID( CNTX, CONS, 1)):
        choiceId = octet_alignedCid;
        octet_aligned = new AsnOcts;
        octet_aligned->BDecContent(b, tag, elmtLen0, bytesDecoded, env);
        break;

      case(MAKE_TAG_ID( CNTX, PRIM, 2)):
      case(MAKE_TAG_ID( CNTX, CONS, 2)):
        choiceId = arbitraryCid;
        arbitrary = new AsnBits;
        arbitrary->BDecContent(b, tag, elmtLen0, bytesDecoded, env);
        break;

      default:
        Asn1Error("ERROR - unexpected tag in CHOICE\n");
        longjmp(env, -64);
        break;
    } /* end switch */
} /* EXTERNALChoice::BDecContent */


void
EXTERNALChoice::Print(ostream& os)
{
    switch(choiceId)
    {
      case(EXTERNALChoice::single_ASN1_typeCid):
        os << "single-ASN1-type ";
        os <<  *single_ASN1_type;
        break;

      case(EXTERNALChoice::octet_alignedCid):
        os << "octet-aligned ";
        os <<  *octet_aligned;
        break;

      case(EXTERNALChoice::arbitraryCid):
        os << "arbitrary ";
        os <<  *arbitrary;
        break;

    } /* end of switch */
}  /* EXTERNALChoice::Print */


AsnLen
EXTERNAL::BEncContent(BUF_TYPE b)
{
    AsnLen totalLen = 0;
    AsnLen l;

    l = encoding->BEncContent(b);
    totalLen += l;

    if (NOT_NULL(data_value_descriptor))
    {
    l = data_value_descriptor->BEncContent(b);
    l += BEncDefLen( b, l);
    l += BEncTag1(b, UNIV, PRIM, OD_TAG_CODE);
    totalLen += l;
    }

    if (NOT_NULL(indirect_reference))
    {
    l = indirect_reference->BEncContent(b);
    BEncDefLenTo127( b, l);
    l++;
    l += BEncTag1(b, UNIV, PRIM, INTEGER_TAG_CODE);
    totalLen += l;
    }

    if (NOT_NULL(direct_reference))
    {
    l = direct_reference->BEncContent(b);
    l += BEncDefLen( b, l);
    l += BEncTag1(b, UNIV, PRIM, OID_TAG_CODE);
    totalLen += l;
    }

    return(totalLen);
} /* EXTERNAL::BEncContent */


void
EXTERNAL::BDecContent(BUF_TYPE b, AsnTag tag0, AsnLen elmtLen0, AsnLen& bytesDecoded, ENV_TYPE env)
{
    AsnTag tag1;
    AsnLen seqBytesDecoded = 0;
    AsnLen elmtLen1;
    tag1 = BDecTag(b, seqBytesDecoded, env);

    if (( tag1 == MAKE_TAG_ID( UNIV, PRIM, OID_TAG_CODE)))
    {
        elmtLen1 = BDecLen(b, seqBytesDecoded, env);
        direct_reference = new AsnOid;
        direct_reference->BDecContent(b, tag1, elmtLen1, seqBytesDecoded, env);
        tag1 = BDecTag(b, seqBytesDecoded, env);
    }

    if (( tag1 == MAKE_TAG_ID( UNIV, PRIM, INTEGER_TAG_CODE)))
    {
        elmtLen1 = BDecLen(b, seqBytesDecoded, env);
        indirect_reference = new AsnInt;
        indirect_reference->BDecContent(b, tag1, elmtLen1, seqBytesDecoded, env);
        tag1 = BDecTag(b, seqBytesDecoded, env);
    }

    if (( tag1 == MAKE_TAG_ID( UNIV, PRIM, OD_TAG_CODE)) ||
        ( tag1 == MAKE_TAG_ID( UNIV, CONS, OD_TAG_CODE)))
    {
        elmtLen1 = BDecLen(b, seqBytesDecoded, env);
        data_value_descriptor = new ObjectDescriptor;
        data_value_descriptor->BDecContent(b, tag1, elmtLen1, seqBytesDecoded, env);
        tag1 = BDecTag(b, seqBytesDecoded, env);
    }

    if (( tag1 == MAKE_TAG_ID( CNTX, CONS, 0)) ||
        ( tag1 == MAKE_TAG_ID( CNTX, PRIM, 1)) ||
    ( tag1 == MAKE_TAG_ID( CNTX, CONS, 1)) ||
        ( tag1 == MAKE_TAG_ID( CNTX, PRIM, 2)) ||
    ( tag1 == MAKE_TAG_ID( CNTX, CONS, 2)))
    {
        elmtLen1 = BDecLen (b, seqBytesDecoded, env);
        encoding = new EXTERNALChoice;
        encoding->BDecContent(b, tag1, elmtLen1, seqBytesDecoded, env);
    }
    else
    {
        Asn1Error("ERROR - SEQUENCE is missing non-optional elmt.\n");
        longjmp(env, -66);
    }

    bytesDecoded += seqBytesDecoded;
    if ( elmtLen0 == INDEFINITE_LEN )
    {
        BDecEoc(b, bytesDecoded, env);
        return;
    }
    else if (seqBytesDecoded != elmtLen0)
    {
        Asn1Error("ERROR - Length discrepancy on sequence.\n");
        longjmp(env, -67);
    }
    else
        return;
} /* EXTERNAL::BDecContent */

void
EXTERNAL::Print(ostream& os)
{
    os << "{  -- SEQUENCE --" << endl;
    indentG += stdIndentG;
    if (NOT_NULL(direct_reference))
    {
    Indent(os, indentG);
    os << "direct-reference ";
    os <<  *direct_reference;
    os << "," << endl;
    }
    if (NOT_NULL(indirect_reference))
    {
    Indent(os, indentG);
    os << "indirect-reference ";
    os <<  *indirect_reference;
    os << "," << endl;
    }
    if (NOT_NULL(data_value_descriptor))
    {
    Indent(os, indentG);
    os << "data-value-descriptor ";
    os <<  *data_value_descriptor;
    os << "," << endl;
    }
    Indent(os, indentG);
    os << "encoding ";
    os <<  *encoding;
    os << endl;
    indentG -= stdIndentG;
    Indent(os, indentG);
    os << "}";
}  /* EXTERNAL::Print */


