/*
 * asn_any.C 
 *
 * MS 92
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#include "asn_config.h"
#include "asn_len.h"
#include "asn_tag.h"
#include "asn_type.h"
#include "asn_oid.h"
#include "asn_int.h"
#include "asn_any.h"


Table* AsnAny::oidHashTbl = NULL;
Table* AsnAny::intHashTbl = NULL;


// Define this ANY value's type to the one that the given id hashes
// to in the ANY table.
void
AsnAny::SetTypeByInt(AsnInt id)
{
    Hash hash;
    void* anyInfo;

    /* use int as hash string */
    hash = MakeHash((char*)&id, sizeof(id));
    if (CheckForAndReturnValue(intHashTbl, hash, &anyInfo))
        ai = (AnyInfo*) anyInfo;
    else
        ai = NULL; /* indicates failure */

} /* SetAnyTypeByInt */

// Define this ANY value's type to the one that the given id hashes
// to in the ANY table.
void AsnAny::SetTypeByOid(AsnOid& id)
{
    Hash hash;
    void* anyInfo;

    /* use encoded oid as hash string */
    hash = MakeHash(id, id.Len());
    if (CheckForAndReturnValue(oidHashTbl, hash, &anyInfo))
        ai = (AnyInfo*) anyInfo;
    else
        ai = NULL; /* indicates failure */

} /* SetAnyTypeByOid */



// Given an integer, intId, to hash on, the type and it's anyId
// are installed in the integer id hash tbl
void 
AsnAny::InstallAnyByInt(AsnInt intId, int anyId, AsnType* type)
{
    AnyInfo* a;
    Hash h;

    a = new AnyInfo;
    //  Oid will be NULL and 0 len by default constructor
    a->anyId = anyId;
    a->intId = intId;
    a->typeToClone = type;

    if (AsnAny::intHashTbl == NULL)
        AsnAny::intHashTbl = InitHash();

    h = MakeHash((char*)&intId, sizeof(intId));
    Insert(AsnAny::intHashTbl, a, h);

}  /* InstallAnyByOid */


// given an OBJECT IDENTIFIER, oid, to hash on, the type and it's anyId
// are installed in the OBJECT IDENTIFIER id hash tbl
void 
AsnAny::InstallAnyByOid(AsnOid& oid, int anyId, AsnType* type)
{
    AnyInfo* a;
    Hash h;

    a =  new AnyInfo;
    a->anyId = anyId;
    a->oid = oid;  // copy given oid
    a->typeToClone = type;

    h = MakeHash(oid, oid.Len());

    if (AsnAny::oidHashTbl == NULL)
        AsnAny::oidHashTbl = InitHash();

    Insert(AsnAny::oidHashTbl, a, h);

}  /* InstallAnyByOid */


//
// if you haven't set up the value properly 
// this will croak (since it's a programming error
// - ie, you didn't initialize the data structure properly
//
AsnLen
AsnAny::BEnc(BUF_TYPE b)
{ 
    return value->BEnc(b);
}



void
AsnAny::BDec(BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env)
{ 
    if (ai == NULL)
        longjmp(env, -81);

    value = ai->typeToClone->Clone();
    
    if (value == NULL)
        longjmp(env, -82);
    else
        value->BDec(b, bytesDecoded, env);
}

