/*
 * hash.h - C++ hash tbl routines
 *
 * Based on hashing stuff from UBC Raven Code (Terry Coatta & Don Acton)
 *
 * MS 92
 * Copyright (C) 1992 the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_hash_h_
#define _asn_hash_h_

#define TABLESIZE 256
#define INDEXMASK 0xFF
#define INDEXSHIFT 8

typedef void* Table[TABLESIZE];

typedef struct HashSlot 
{
  int    leaf;
  int    hash;
  void*  value;
  Table* table;
} HashSlot;

typedef unsigned long int Hash;

Hash MakeHash(char *str, unsigned long int len);

Table* InitHash();

int Insert(Table* table, void* element, Hash hash);

int CheckFor(Table* table, Hash hash);

int CheckForAndReturnValue(Table* table, Hash hash, void** value);


#endif /* conditional include */
