/*
 *  asn_real.h - ASN.1 REAL type
 * 
 *  Mike Sample
 *  92/07/02
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_real_h_
#define _asn_real_h_


class AsnReal: public AsnType
{
  protected:
    double value;

  public:
    operator double() const  { return value; }
    AsnReal(): value(0.0) {}
    AsnReal(double val): value(val) { }

    void Print(ostream& os) { os << value; }

    AsnType* Clone() { return new AsnReal; }

    AsnLen BEnc( BUF_TYPE b)
    {
        AsnLen l;
        l =  BEncContent(b); 
        l += BEncDefLen(b, l);
        l += BEncTag1(b, UNIV, PRIM, REAL_TAG_CODE);
        return (l);
    }

    void BDec( BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env)
    {
        AsnLen elmtLen;
        if (BDecTag(b, bytesDecoded, env) != MAKE_TAG_ID(UNIV, PRIM, REAL_TAG_CODE))
        {
            Asn1Error("AsnReal::BDec: ERROR tag on REAL is wrong.\n");
            longjmp(env,-58);
        }
        elmtLen = BDecLen(b, bytesDecoded, env);

        BDecContent(b, MAKE_TAG_ID(UNIV, PRIM, REAL_TAG_CODE), elmtLen,
                         bytesDecoded, env);
    }


    AsnLen BEncContent( BUF_TYPE b);

    void BDecContent( BUF_TYPE b, AsnTag tagId, AsnLen elmtLen,
                          AsnLen& bytesDecoded, ENV_TYPE env);

    PDU_MEMBER_MACROS
};


extern const AsnReal PLUS_INFINITY;
extern const AsnReal MINUS_INFINITY;



#endif /* conditional include */
