/*
 * asn_null.h  - c++ version of ASN.1 NULL 
 *
 * MS 92/06/15
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_null_h_
#define _asn_null_h_

class AsnNull : public AsnType
{
  public:

    AsnNull() {}
    void Print(ostream& os) { os << "NULL"; }
    AsnType* Clone() { return new AsnNull; }

    AsnLen BEnc( BUF_TYPE b)
    {
        AsnLen l;
        l = BEncContent(b); 
        BEncDefLenTo127(b, l);
        l++;
        l += BEncTag1(b, UNIV, PRIM, NULLTYPE_TAG_CODE);
        return (l);
    }

    void BDec( BUF_TYPE b, AsnLen& bytesDecoded,
                    ENV_TYPE env)
    {
        AsnLen elmtLen;
        if (BDecTag(b, bytesDecoded, env) != MAKE_TAG_ID(UNIV, PRIM, NULLTYPE_TAG_CODE))
        {
            Asn1Error("AsnNull::BDec: ERROR tag on NULL is wrong.\n");
            longjmp(env,-55);
        }

        elmtLen = BDecLen(b, bytesDecoded, env);
        BDecContent(b, MAKE_TAG_ID(UNIV, PRIM, NULLTYPE_TAG_CODE), elmtLen,
                         bytesDecoded, env);
    }

    AsnLen BEncContent( BUF_TYPE b)
    {
        return(0);
    }

    void BDecContent( BUF_TYPE b, AsnTag tagId, AsnLen elmtLen,
                           AsnLen& bytesDecoded, ENV_TYPE env);


    PDU_MEMBER_MACROS
};


#endif /* conditional include */
