/*
 *  asn_list.h
 *
 *   **** NOTE - this is not used or tested due to problems with gcc ****
 * 
 *  Mike Sample
 *  92/07/02
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_list_h_
#define _asn_list_h_

template <class T> 
class AsnList
{
    protected:
    unsigned long int count;
    struct AsnListElmt
    {
        T elmt;
        AsnListElmt* next;
        AsnListElmt* prev;
    } *first, *curr, *last;

    public:

    friend ostream& operator<<(ostream& os, AsnList& l);

    AsnList(): count(0), first(NULL), curr(NULL), last(NULL) { }


    void SetCurrElmt(unsigned long int index);
    void SetCurrToFirst() { curr = first; }
    void SetCurrToLast()  { curr = last; }

    // reading member fcns
    int Count() { return count; }
    T* First() { if (count > 0) return(&first->elmt) ; else return(NULL); }
    T* Last()  { if (count > 0) return(&last->elmt) ; else return(NULL); }
    T* Curr()  { if (curr != NULL) return(&curr->elmt) ; else return(NULL); }
    T* Next()  { if ((curr != NULL)&& (curr->next != NULL)) return(&curr->next->elmt) ; else return(NULL); }
    T* Prev()  { if ((curr != NULL)&& (curr->prev != NULL)) return(&curr->prev->elmt) ; else return(NULL); }
         
    // routines that move the curr elmt
    T* GoNext() { if (curr != NULL) curr = curr->next; return(Curr()); }
    T* GoPrev() { if (curr != NULL) curr = curr->prev; return(Curr()); }

    // write & alloc fcns - returns new elmt
    T& Append();  // add elmt to end of list
    T& Prepend(); // add elmt to begginning of list
//    T& InsertBefore();   insert elmt before current elmt
//    T& InsertAfter();   insert elmt after current elmt

    // write & alloc & copy - returns list after copying elmt
    AsnList& AppendAndCopy(T& elmt);  // add elmt to end of list
    AsnList& PrependAndCopy(T& elmt); // add elmt to begginning of list
//    AsnList& InsertBeforeAndCopy(T& elmt);   insert elmt before current elmt
//    AsnList& InsertAfterAndCopy(T& elmt);  insert elmt after current elmt

    // encode and decode routines    
    AsnLen BEnc( BUF_TYPE b)
    {
        AsnLen l;
        l =  BEncContent(b); 
        l += BEncDefLen(b, l);
        l += BEncTag1(b, UNIV, CONS, SEQ_TAG_CODE);
        return (l);
    }

    void BDec( BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env)
    {
        AsnLen elmtLen;
        if (BDecTag(b, bytesDecoded, env) != MAKE_TAG_ID(UNIV, CONS, SEQ_TAG_CODE))
        {
            Asn1Error("AsnList::BDec: ERROR tag on SEQUENCE OF is wrong.\n");
            longjmp(env,-54);
        }
        elmtLen = BDecLen(b, bytesDecoded, env);

        BDecContent(b, MAKE_TAG_ID(UNIV, CONS, SEQ_TAG_CODE),
                         elmtLen, bytesDecoded, env);
    }

    AsnLen BEncContent( BUF_TYPE b)
    {
        AsnListElmt* currElmt;
        AsnLen sum = 0;

        for (currElmt = last; currElmt != NULL; currElmt = currElmt->prev)
            sum += currElmt->elmt.BEnc(b);

        return(sum);
    }

    void BDecContent( BUF_TYPE b, AsnTag tagId, AsnLen elmtLen,
                           AsnLen& bytesDecoded, ENV_TYPE env);

    PDU_MEMBER_MACROS

};


// This causes gcc2 on C++ to choke

/*
template <class T, class U>
int ListsEquiv(AsnList<T>& l1, AsnList<U>& l2);

template <class T, class U>
inline int operator==(AsnList<T>& l1, AsnList<U>& l2)
{
    return(ListsEquiv(l1, l2));
}

template <class T, class U>
inline int operator!=(AsnList<T>& l1, AsnList<U>& l2)
{
    return(!ListsEquiv(l1,l2));
}
*/

#endif /* conditional include */
