/*
 * asn_int.h  - c++ version of ASN.1 integer 
 *
 * MS 92/06/15
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_int_h_
#define _asn_int_h_

class AsnInt : public AsnType
{
  protected:
    long int value;

  public:

    operator long int() { return value; }
    AsnInt(long int val): value(val) {}
    AsnInt() {}

    void Print(ostream& os) { os << value; }
    AsnType* Clone() { return new AsnInt; }

    AsnLen BEnc( BUF_TYPE b)
    {
        AsnLen l;
        l = BEncContent(b); 
        BEncDefLenTo127(b, l);
        l++;
        l += BEncTag1(b, UNIV, PRIM, INTEGER_TAG_CODE);
        return (l);
    }

    void BDec( BUF_TYPE b, AsnLen& bytesDecoded,
                    ENV_TYPE env)
    {
        AsnLen elmtLen;
        if (BDecTag(b, bytesDecoded, env) != MAKE_TAG_ID(UNIV, PRIM, INTEGER_TAG_CODE))
        {
            Asn1Error("AsnInt::BDec: ERROR tag on INTEGER is wrong.\n");
            longjmp(env,-53);
        }

        elmtLen = BDecLen(b, bytesDecoded, env);
        BDecContent(b, MAKE_TAG_ID(UNIV, PRIM, INTEGER_TAG_CODE), elmtLen,
                         bytesDecoded, env);
    }

    AsnLen BEncContent( BUF_TYPE b);

    void BDecContent( BUF_TYPE b, AsnTag tagId, AsnLen elmtLen,
                           AsnLen& bytesDecoded, ENV_TYPE env);


    PDU_MEMBER_MACROS
};


#endif /* conditional include */

