/*
 * asn_config.h - decoder alloc routines and buffer routines
 *                and other configuration stuff.
 *
 * MS 92/06/18
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_config_h_
#define _asn_config_h_

#include <ctype.h>  /* for isprint() in <<op on AsnOcts */
#include <iostream.h> 
#include <memory.h>
#include <string.h>
#include <setjmp.h>
#include <math.h> /* to get ieee conversion functions & pow */


/*
 * define IEEE_REAL_FMT if your system/compiler uses the native ieee double
 * this should improve the performance of encoding reals.
 * If your system has the IEEE library routines (iszero, isinf etc)
 * then define IEEE_REAL_LIB.  If neither are defined then
 * frexp is used.  Performance is probaby best for IEEE_REAL_FMT.
 *
 *  #define IEEE_REAL_FMT
 *  #define IEEE_REAL_LIB
 */



#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

/* used to test if optionals are present */
#define NOT_NULL(ptr) ((ptr) != NULL)


/*
 * Asn1Error(char* str) 
 *  - configure error handler
 */
#define Asn1Error(str) cerr << str;


/*
 * Asn1Warning(char* str)  - configure warning mechanism
 * (currently not called)
 */
#define Asn1Warning(str) cerr << str;


/*
 * configure memory scheme used by decoder to allocate memory
 * for the decoded value.  The include file name cannot be
 * be null.
 */
#define Asn1New(class)     new class
#define Asn1Delete(ptr)    delete ptr
#define Asn1Alloc(size)    new char[size]
#define Asn1Free(ptr)      delete ptr

#include "asn_buf.h"
#define BUF_TYPE AsnBuf&
#define ENV_TYPE jmp_buf

/* return true if succeeded, false otherwise */
#define PDU_MEMBER_MACROS\
    int BEncPdu( BUF_TYPE b, AsnLen& bytesEncoded)\
    {\
        bytesEncoded = BEnc(b);\
        return(!b.WriteError());\
    }\
\
    int BDecPdu( BUF_TYPE b, AsnLen& bytesDecoded)\
    {\
        jmp_buf env;\
        int val;\
\
        bytesDecoded = 0;\
        if ((val = setjmp(env)) == 0 )\
        {\
            BDec(b, bytesDecoded, env);\
            return(!b.ReadError());\
        }\
        else\
            return(FALSE);\
    }


#endif /* conditional include */
