/*
 * asn_buf.h  - buffer class 
 * 
 * MS 92
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_buf_h_
#define _asn_buf_h_

class AsnBuf
{
    protected:
    char* dataStart;
    char* dataEnd;
    char* blkStart;
    char* blkEnd;
    char* readLoc;
    int writeError;
    int readError;
    
    // install data for reading or blank blk for writing in buffer
    // must be followed by 'mode' setting method call
    public:
    void Init( char* data, unsigned long int dataLen)
    { 
        readError = writeError = 1;
        blkStart = data;
        blkEnd = data + dataLen;
        dataStart = dataEnd = readLoc = blkEnd;
    }

    void ResetInReadMode() 
    { 
        readLoc = dataStart;
        readError = 0;
        writeError = 1;
    }

    void ResetInWriteRvsMode()
    {
        dataStart = dataEnd = blkEnd;
        writeError = 0;
        readError = 1; 
    }

    void InstallData(char* data, unsigned long int dataLen)
    {
        Init(data, dataLen);
        dataStart = blkStart;
        ResetInReadMode();
    }  

    unsigned long int DataLen() { return (dataEnd - dataStart); }
    char*             DataPtr() { return (dataStart); }
    unsigned long int BlkLen()  { return (blkEnd - blkStart); }
    char*             BlkPtr()  { return (blkStart); }
    int               Eod()     { return (readLoc >= dataEnd); }
    int               ReadError() { return (readError); }
    int               WriteError() { return (writeError); }

    void Skip(unsigned long int skipLen)
    {
        if ( (readLoc + skipLen) > dataEnd)
        {
            readLoc = dataEnd;
            readError = 1;
        }
        else
            readLoc += skipLen;
    }

    unsigned long int Copy( char* dst, unsigned long int copyLen)
    {
        if ((readLoc + copyLen) > dataEnd)
        {
            memcpy(dst, readLoc, dataEnd - readLoc);
            readLoc = dataEnd;
            readError = 1;
            return(dataEnd - readLoc);
        }
        else
        {
            memcpy(dst, readLoc, copyLen);
            readLoc += copyLen;
            return(copyLen);
        }
    }

    unsigned char PeekByte()                      
    {
        if (Eod())
        {
            readError = 1;
            return(0);
        }
        else
            return(*readLoc);
    }

    char* GetSeg(unsigned long int* lenPtr)
    { 
        char* retVal = readLoc;
        if ((readLoc + *lenPtr) > dataEnd)
        {
            *lenPtr = dataEnd - readLoc;
            readLoc = dataEnd;
            return(retVal);
        }
        else
        {
            readLoc += *lenPtr;
            return(retVal);
        }
    }

    void PutSegRvs( char* seg, unsigned long int segLen)
    {
        if ((dataStart - segLen) < blkStart)
            writeError = 1;
        else
        {
            dataStart -= segLen;
            memcpy(dataStart, seg, segLen);
        }
    }
                         
    unsigned char GetByte()
    {
        if (Eod())
        {
            readError = 1;
            return(0);
        }
        else
            return(*(readLoc++));
    }

    void PutByteRvs(unsigned char byte)
    {
        if (dataStart <= blkStart)
            writeError = 1;
        else
            *(--dataStart) = byte;
    }
                          
};

#endif /* conditional include */
