/*
 * asn_bool.h  - c++ version of ASN.1 integer 
 *
 * MS 92/06/15
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_bool_h_
#define _asn_bool_h_

class AsnBool: public AsnType
{
  protected:
    unsigned char value;

  public:
    enum { false = 0, true = 1};
    operator int() { return value; }
    AsnBool(const int val): value(val != false) {};
    AsnBool() {};

    void Print(ostream& os);
    AsnType* Clone() { return new AsnBool; }

    AsnLen BEnc( BUF_TYPE b)
    {
        AsnLen l;
        l = BEncContent(b); 
        BEncDefLenTo127(b, l);
        l++;
        l += BEncTag1(b, UNIV, PRIM, BOOLEAN_TAG_CODE);
        return (l);
    }

    void BDec( BUF_TYPE b, AsnLen& bytesDecoded,
                   ENV_TYPE env)
    {
        AsnLen elmtLen;
        if (BDecTag(b, bytesDecoded, env) != MAKE_TAG_ID(UNIV, PRIM, BOOLEAN_TAG_CODE))
        {
            Asn1Error("AsnBool::BDec: ERROR tag on BOOLEAN wrong.\n");
            longjmp(env,-51);
        }
        elmtLen = BDecLen(b, bytesDecoded, env);

        BDecContent(b, MAKE_TAG_ID(UNIV, PRIM, BOOLEAN_TAG_CODE), elmtLen,
                         bytesDecoded, env);
    }

    AsnLen BEncContent( BUF_TYPE b) 
    { 
        b.PutByteRvs( (value ? 0xFF : 0) );
        return (1);
    }

    void BDecContent( BUF_TYPE b, AsnTag tagId, AsnLen elmtLen,
                          AsnLen& bytesDecoded, ENV_TYPE env);

    PDU_MEMBER_MACROS

};


#endif /* conditional include */
