/*
 *  asn_bits.h - ASN.1 BIT STRING type
 * 
 *  Mike Sample
 *  92/07/02
 * Copyright (C) 1992 Michael Sample and the University of British Columbia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 */

#ifndef _asn_bits_h_
#define _asn_bits_h_

extern char numToHexCharTblG[]; 
#define TO_HEX(fourBits) (numToHexCharTblG[(fourBits) & 0x0F])


class AsnBits: public AsnType
{
  protected:
    char* bits;
    unsigned long int bitLen;

  public:
    AsnBits() { bits = NULL; bitLen = 0; }
    AsnBits(const unsigned long int numBits) { Set(numBits); }
    AsnBits(const char* bitOcts, const unsigned long int numBits) 
    { 
        Set(bitOcts, numBits);
    }
    AsnBits(const AsnBits& b) { Set(b); }
    ~AsnBits() {delete bits;}                                               

    AsnBits& operator=(const AsnBits& b) { ReSet(b); return *this;}

    // overwrite existing bits and bitLen values
    void Set(unsigned long int numBits);
    void Set(const char* bitOcts, unsigned long int numBits);
    void Set(const AsnBits& b);

    // free old bits value, the reset bits and bitLen values
    void ReSet(const unsigned long int numBits);
    void ReSet(const char* bitOcts, unsigned long int numBits);
    void ReSet(const AsnBits& b);

    operator==(AsnBits& ab)  { return(BitsEquiv(ab)); }
    operator!=(AsnBits& ab)  { return(!BitsEquiv(ab)); }

    void SetBit(unsigned long int);
    void ClrBit(unsigned long int);
    int  GetBit(unsigned long int);

    unsigned long int BitLen() {return bitLen;}

    AsnLen BEnc( BUF_TYPE b)
    {
        AsnLen l;
        l =  BEncContent(b); 
        l += BEncDefLen(b, l);
        l += BEncTag1(b, UNIV, PRIM, BITSTRING_TAG_CODE);
        return (l);
    }

    void BDec( BUF_TYPE b, AsnLen& bytesDecoded, ENV_TYPE env)
    {
        AsnLen elmtLen;
        AsnTag tag;

        tag = BDecTag(b, bytesDecoded, env);
        if ((tag != MAKE_TAG_ID(UNIV, PRIM, BITSTRING_TAG_CODE)) &&
            (tag != MAKE_TAG_ID(UNIV, CONS, BITSTRING_TAG_CODE)))
        {
            Asn1Error("AsnBits::BDec: ERROR tag on BIT STRING is wrong.\n");
            longjmp(env,-50);
        }
        elmtLen = BDecLen(b, bytesDecoded, env);
        BDecContent(b, tag, elmtLen, bytesDecoded, env);
    }

    AsnLen BEncContent( BUF_TYPE b);

    void BDecContent( BUF_TYPE b, AsnTag tagId, AsnLen elmtLen,
                          AsnLen& bytesDecoded, ENV_TYPE env);

    PDU_MEMBER_MACROS

    AsnType* Clone() { return new AsnBits; }
    void Print(ostream& os);

  private:
    int BitsEquiv(AsnBits& ab);
    void BDecConsBits (BUF_TYPE b, AsnLen elmtLen,
                                      AsnLen& bytesDecoded, ENV_TYPE env);
    void FillBitStringStk (BUF_TYPE b, AsnLen elmtLen0, 
                           AsnLen& bytesDecoded, ENV_TYPE env);

};



#endif /* conditional include */
