 //
// genber.C - builds an PersonnelRecord value and writes BER form
//            of the value to a file called "pr.ber"
//
//
// MS 92



#include <stddef.h>
#include <stdlib.h>
#include <errno.h>
#include <fstream.h>
#include "asn_incl.h"
#include "p_rec.h"


main (int argc, char* argv[])
{
    ofstream outputFile;
    AsnBuf outputBuf;
    unsigned long int encodedLen;
    int dataSize = 1024;
    char data[1024];
    ChildInformation* ciPtr;
    PersonnelRecord pr;

    // build internal value of a PersonnelRecord
    pr.name = new Name;
    pr.name->givenName = "John";  // this calls pr.name->givenName.Set("John");
    pr.name->initial = "E";       
    pr.name->familyName = "Smith";

    pr.title.Set("The Big Cheese");
    pr.employeeNumber = 99999;
    pr.dateOfHire.Set("19820104");

    pr.nameOfSpouse = new Name;
    pr.nameOfSpouse->givenName.Set("Mary");
    pr.nameOfSpouse->initial.Set("L");
    pr.nameOfSpouse->familyName.Set("Smith");

    pr.children = new PersonnelRecordSeqOf;
    
    ciPtr = pr.children->Append();
    ciPtr->name = new Name;
    ciPtr->name->givenName.Set("James");
    ciPtr->name->initial.Set("R");
    ciPtr->name->familyName.Set("Smith");
    ciPtr->dateOfBirth.Set("19570310");

    ciPtr = pr.children->Append();
    ciPtr->name = new Name;
    ciPtr->name->givenName.Set("Lisa");
    ciPtr->name->initial.Set("M");
    ciPtr->name->familyName.Set("Smith");
    ciPtr->dateOfBirth.Set("19610621");


    // set up buffer for writing to
    outputBuf.Init(data, dataSize);
    outputBuf.ResetInWriteRvsMode();

    // encode the internal value we just build into the buffer
    if (!pr.BEncPdu(outputBuf, encodedLen))
        cout << "failed encoding AnyTestType value" << endl;

    // open file to hold the BER value
    outputFile.open("pr.ber");
    if (!outputFile)
    {
        perror("ofstream::open");
        exit(1);
    }

    // copy the BER value from the buffer to the file
    outputBuf.ResetInReadMode();
    for ( ; encodedLen > 0; encodedLen--)
        outputFile.put(outputBuf.GetByte());


    cout << "Wrote the following BER PersonnelRecord value to pr.ber." << endl;
    cout << "Test it with \"def\" and \"indef\"." << endl;
    cout << pr << endl;

    return(0);
}


