//
// example.C - an example of how to use  C++ ASN.1-BER 
//             encoders and decoders generated by snacc
//
// AUTHOR: Mike Sample
// DATE:   Aug 92
//

#include <stddef.h>
#include <stdlib.h>
#include <errno.h>
#include <fstream.h>
#include "asn_incl.h"
#include "p_rec.h"


main (int argc, char* argv[])
{
    AsnBuf  inputBuf;
    AsnBuf  outputBuf;
    unsigned long int encodedLen;
    unsigned long int decodedLen;
    int      dataSize;
    ifstream dataFile;
    PersonnelRecord pr;

    if (argc != 2)
    {
        cerr << "Usage: " << argv[0] << " <BER data file name>" << endl;
        cerr << "   Decodes the given PersonnelRecord BER data file" << endl;
        cerr << "   and re-encodes it to stdout" << endl;
        exit(1);
    }


    // open the data file
    dataFile.open(argv[1]);

    if (!dataFile)
    {
        perror("ifstream::open");
        exit(1);
    }

    // get size of the data file file
    dataFile.seekg(0, ios::end);
    dataSize = dataFile.tellg();
    dataFile.seekg(0);

    // read data from file into contiguous block for a buffer
    char data[dataSize];
    dataFile.read(data, dataSize);
    dataFile.close();

    //
    // put the BER data read from the file
    // into buffer format, ready for reading from the
    // beginning
    //
    inputBuf.InstallData(data, dataSize);

    if (!pr.BDecPdu(inputBuf, decodedLen))
    {
        cerr << "ERROR - Decode routines failed, exiting..." << endl;
        exit(1);
    }

    cerr  << "decodedValue PersonnelRecord ::= " << pr << endl << endl;

    //
    // allocate a new buffer set up for writing to
    //
    char outputData[dataSize + 512];
    outputBuf.Init(outputData, dataSize+512);
    outputBuf.ResetInWriteRvsMode();

    if (!pr.BEncPdu(outputBuf, encodedLen))
    {
        cerr << "ERROR - Encode routines failed" << endl;
    }

    // write the BER value to cout
    outputBuf.ResetInReadMode();
    for ( ; encodedLen > 0; encodedLen--)
        cout.put(outputBuf.GetByte());

    return(0);
}
